/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.analytics.collector.agent.JMXMetricHandler;
import com.mulesoft.analytics.collector.agent.MetricProvider;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.util.Tuple;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JMXOperatingSystemMetricProvider
implements MetricProvider {
    private static final Logger LOGGER = LogManager.getLogger(JMXMetricHandler.class);
    private static final String MEASURE = "operatingsystem";
    static final ImmutableMap<String, String> OS_METRICS = ImmutableMap.builder().put((Object)"CommittedVirtualMemorySize", (Object)"commited_virtual_memory_size").put((Object)"TotalSwapSpaceSize", (Object)"total_swap_space_size").put((Object)"FreeSwapSpaceSize", (Object)"free_swap_space_size").put((Object)"ProcessCpuTime", (Object)"process_cpu_time").put((Object)"FreePhysicalMemorySize", (Object)"free_physical_memory_size").put((Object)"SystemCpuLoad", (Object)"system_cpu_load").build();
    volatile boolean enabled = true;

    @Override
    public Collection<MetricRecord> getMetrics(List<Tuple<String, String>> tags) {
        return this.getMetrics(tags, (Map<String, String>)OS_METRICS);
    }

    Collection<MetricRecord> getMetrics(List<Tuple<String, String>> tags, Map<String, String> osMetrics) {
        ArrayList<MetricRecord> metrics = new ArrayList<MetricRecord>();
        if (this.enabled) {
            try {
                ObjectName operatingSystem = new ObjectName("java.lang", "type", "OperatingSystem");
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                for (Map.Entry<String, String> attributeName : osMetrics.entrySet()) {
                    Object attribute = JMXOperatingSystemMetricProvider.tryGetAttribute(mBeanServer, operatingSystem, attributeName.getKey());
                    if (!(attribute instanceof Number)) continue;
                    Tuple<String, String> tuple = Tuple.tuple(attributeName.getValue(), attribute.toString());
                    metrics.add(MetricRecord.create(MEASURE, tags, Collections.singletonList(tuple)));
                }
                if (metrics.isEmpty()) {
                    this.enabled = false;
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception for OperatingSystem MBean", (Throwable)e);
                this.enabled = false;
            }
        }
        return metrics;
    }

    @Nullable
    static Object tryGetAttribute(MBeanServer mBeanServer, ObjectName operatingSystem, String key) throws MBeanException, InstanceNotFoundException, ReflectionException {
        try {
            return mBeanServer.getAttribute(operatingSystem, key);
        }
        catch (AttributeNotFoundException e) {
            LOGGER.debug("Attribute not found in OperatingSystem MBean: " + key);
            return null;
        }
    }
}

