/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec;

import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECConstants;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECCurve;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECFieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECLookupTable;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECPoint;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecP128R1Field;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecP128R1FieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecP128R1Point;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.raw.Nat128;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP128R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP128R1FieldElement.Q;
    private static final int SECP128R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP128R1_AFFINE_ZS = new ECFieldElement[]{new SecP128R1FieldElement(ECConstants.ONE)};
    protected SecP128R1Point infinity = new SecP128R1Point((ECCurve)this, null, null);

    public SecP128R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("E87579C11079F43DD824993C2CEE5ED3")));
        this.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFE0000000075A30D1B9038A115"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP128R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP128R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP128R1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP128R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 4 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat128.copy((int[])((SecP128R1FieldElement)eCPoint.getRawXCoord()).x, (int)0, (int[])nArray, (int)n3);
            Nat128.copy((int[])((SecP128R1FieldElement)eCPoint.getRawYCoord()).x, (int)0, (int[])nArray, (int)(n3 += 4));
            n3 += 4;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat128.create();
        SecP128R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat128.create();
        SecP128R1Field.randomMult((SecureRandom)secureRandom, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECP128R1_AFFINE_ZS;
    }
}

