/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.data;

import com.mulesoft.analytics.limiter.data.OtherValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ValueVector {
    private final Object[] valueArray;
    private int cachedHashCode = -1;

    public ValueVector(Object[] values) {
        this.valueArray = values;
    }

    public boolean hasOtherValue() {
        for (int i = 0; i < this.valueArray.length; ++i) {
            if (this.valueArray[i] != OtherValue.OTHER) continue;
            return true;
        }
        return false;
    }

    public Object[] getValues() {
        return this.valueArray;
    }

    public boolean[] getOtherValues() {
        boolean[] results = new boolean[this.valueArray.length];
        for (int i = 0; i < this.valueArray.length; ++i) {
            results[i] = this.valueArray[i] == OtherValue.OTHER;
        }
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        int length = this.valueArray.length;
        ValueVector other = (ValueVector)o;
        if (other.valueArray.length != length) {
            return false;
        }
        if (other.cachedHashCode != 0 && this.cachedHashCode != 0 && other.cachedHashCode != this.cachedHashCode) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object o1 = this.valueArray[i];
            Object o2 = other.valueArray[i];
            if (o1 == o2 || o1 != null && o2 != null && o1 != OtherValue.OTHER && o2 != OtherValue.OTHER && o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            this.cachedHashCode = this.calculateHashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return "[" + StringUtils.join((Object[])this.valueArray, (String)", ") + "]";
    }

    private int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.valueArray);
        return builder.hashCode();
    }
}

