/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent;

import com.mulesoft.dias.mule.agent.CertificateProcessor;
import com.mulesoft.dias.mule.agent.DefaultFileWatchService;
import com.mulesoft.dias.mule.agent.FileWatchService;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.FileProcessingUtils;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DirectoryWatcher {
    private final FileWatchService watchService;
    private final Set<Path> watchedFiles = new HashSet<Path>();
    private final Map<WatchKey, Path> watchKeys = new HashMap<WatchKey, Path>();
    private final CertificateProcessor certificateProcessor;
    private final Path otelConfigPath;
    private final Path muleAgentJksPath;
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win");
    private static final Map<Path, String> fileHashes = new HashMap<Path, String>();
    private final ScheduledExecutorService restartScheduler = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean restartScheduled = new AtomicBoolean(false);
    private final AtomicInteger pendingRestartCount = new AtomicInteger(0);
    private static final int RESTART_DEBOUNCE_SECONDS = 15;
    private volatile boolean shutdownRequested = false;

    public DirectoryWatcher(FileWatchService watchService) throws IOException {
        String muleHome = System.getProperty("muleHome");
        if (muleHome == null || muleHome.isEmpty()) {
            throw new IllegalStateException("muleHome system property is not set");
        }
        this.watchService = watchService;
        this.certificateProcessor = new CertificateProcessor();
        this.otelConfigPath = MuleHomePath.getAMConfigPath("pipelines/otel-config.yml").toAbsolutePath();
        this.muleAgentJksPath = MuleHomePath.getConfigPath("mule-agent.jks").toAbsolutePath();
        if (Files.exists(this.otelConfigPath.getParent(), new LinkOption[0])) {
            this.processAllYamlFilesOnStartup();
        }
        this.preloadHashes();
        this.registerDirectory(this.otelConfigPath.getParent());
        this.registerDirectory(this.muleAgentJksPath.getParent());
        ConsoleLogger.info("DirectoryWatcher initialized - monitoring " + this.watchKeys.size() + " directories for changes");
        new Thread(this::monitorForNewDirectoriesAndFiles).start();
    }

    private void processAllYamlFilesOnStartup() {
        try {
            final int[] processedFileStats = new int[]{0, 0};
            Files.walkFileTree(this.otelConfigPath.getParent(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (isWindows && file.toString().toLowerCase().endsWith(".yml")) {
                        processedFileStats[0] = processedFileStats[0] + 1;
                        boolean converted = DirectoryWatcher.convertWindowsPathsToUnix(file, true);
                        if (converted) {
                            processedFileStats[1] = processedFileStats[1] + 1;
                            ConsoleLogger.info("Converted Windows paths in: " + file.getFileName());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (processedFileStats[0] > 0) {
                ConsoleLogger.info("Startup: Processed " + processedFileStats[0] + " YAML files, " + processedFileStats[1] + " required Windows path conversion");
            }
        }
        catch (IOException e) {
            ConsoleLogger.error("Error while processing YAML files: " + e.getMessage());
        }
    }

    private void preloadHashes() {
        try {
            Files.walkFileTree(this.otelConfigPath.getParent(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (isWindows && file.toString().toLowerCase().endsWith(".yml")) {
                        fileHashes.put(file, DirectoryWatcher.this.hashContent(file));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            ConsoleLogger.error("Error while preloading hashes: " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private String hashContent(Path file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String hashContent(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(content.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            ConsoleLogger.error("Error hashing content " + content);
            e.printStackTrace(System.err);
            throw new RuntimeException("SHA-256 not supported", e);
        }
    }

    public DirectoryWatcher() throws IOException {
        this(new DefaultFileWatchService());
    }

    private void registerDirectory(Path directory) throws IOException {
        if (this.watchKeys.containsValue(directory)) {
            return;
        }
        WatchKey key = this.watchService.registerDirectory(directory);
        this.watchKeys.put(key, directory);
        ConsoleLogger.debug("Registered directory watcher: " + directory.getFileName());
    }

    private boolean checkAndRegisterFile(Path file) {
        if (Files.exists(file, new LinkOption[0]) && !this.watchedFiles.contains(file)) {
            boolean converted;
            this.watchedFiles.add(file);
            if (isWindows && file.toString().toLowerCase().endsWith(".yml") && (converted = DirectoryWatcher.convertWindowsPathsToUnix(file, true))) {
                ConsoleLogger.info("Converted Windows paths in startup file: " + file.getFileName());
            }
            ConsoleLogger.info("Now watching: " + file.getFileName());
            return true;
        }
        if (!this.watchedFiles.contains(file)) {
            ConsoleLogger.debug("File not found, will retry: " + file.getFileName());
        }
        return false;
    }

    private void monitorForNewDirectoriesAndFiles() {
        boolean otelConfigFound = false;
        boolean muleAgentJksFound = false;
        try {
            do {
                TimeUnit.SECONDS.sleep(5L);
                if (!otelConfigFound) {
                    otelConfigFound = this.checkAndRegisterFile(this.otelConfigPath);
                }
                if (muleAgentJksFound) continue;
                muleAgentJksFound = this.checkAndRegisterFile(this.muleAgentJksPath);
            } while (!otelConfigFound || !muleAgentJksFound);
            ConsoleLogger.info("All required files are now being watched.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean convertWindowsPathsToUnix(Path yamlFilePath) {
        return DirectoryWatcher.convertWindowsPathsToUnix(yamlFilePath, false);
    }

    public static boolean convertWindowsPathsToUnix(Path yamlFilePath, boolean silentMode) {
        if (!isWindows) {
            if (!silentMode) {
                ConsoleLogger.debug("Skip converting paths in YML file because it's not Windows OS: " + yamlFilePath);
            }
            return false;
        }
        if (!silentMode) {
            ConsoleLogger.info("Analyzing file for Windows paths: " + yamlFilePath.getFileName());
        }
        try {
            byte[] bytes = Files.readAllBytes(yamlFilePath);
            String originalContent = new String(bytes, StandardCharsets.UTF_8);
            boolean containsWindowsPaths = originalContent.contains("\\");
            if (!containsWindowsPaths) {
                if (!silentMode) {
                    ConsoleLogger.debug("No Windows paths found in: " + yamlFilePath.getFileName());
                }
                return false;
            }
            if (!silentMode) {
                ConsoleLogger.debug("Processing " + yamlFilePath.getFileName() + " (" + bytes.length + " bytes)");
            }
            boolean hasPathChanges = false;
            StringBuilder updatedContent = new StringBuilder();
            hasPathChanges = FileProcessingUtils.processContent(originalContent, updatedContent);
            String originalHash = DirectoryWatcher.hashContent(originalContent);
            String storedHash = fileHashes.getOrDefault(yamlFilePath, "");
            String finalContent = updatedContent.toString();
            String newHash = DirectoryWatcher.hashContent(finalContent);
            if (!(!hasPathChanges || originalHash.equals(storedHash) && originalHash.equals(newHash))) {
                if (!silentMode) {
                    ConsoleLogger.info("Windows paths converted and saved to: " + yamlFilePath.getFileName());
                }
                Files.write(yamlFilePath, finalContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                fileHashes.put(yamlFilePath, newHash);
                return true;
            }
            if (!silentMode && hasPathChanges) {
                ConsoleLogger.debug("File content unchanged - no write needed for: " + yamlFilePath.getFileName());
            }
            return false;
        }
        catch (IOException e) {
            ConsoleLogger.error("Failed to convert paths in YAML file: " + yamlFilePath.getFileName() + " - " + e.getMessage());
            if (!silentMode) {
                e.printStackTrace(System.err);
            }
            return false;
        }
        catch (Exception e) {
            ConsoleLogger.error("Unexpected error converting paths in YAML file: " + yamlFilePath.getFileName() + " - " + e.getMessage());
            if (!silentMode) {
                e.printStackTrace(System.err);
            }
            return false;
        }
    }

    private boolean isTemporaryFile(Path file) {
        if (file == null) {
            return true;
        }
        String fileName = file.getFileName().toString();
        return fileName.startsWith(".") || fileName.endsWith(".swp") || fileName.endsWith(".tmp") || fileName.endsWith(".bak") || fileName.endsWith(".backup") || fileName.endsWith("~") || fileName.contains(".tmp.") || fileName.contains(".bak.") || fileName.startsWith("~") || fileName.contains("#") || fileName.endsWith(".orig");
    }

    public void watch() {
        ConsoleLogger.info("DirectoryWatcher active - monitoring " + this.watchKeys.size() + " directories for file changes");
        block3: while (true) {
            try {
                while (true) {
                    boolean valid;
                    WatchKey key;
                    Path dir;
                    if ((dir = this.watchKeys.get(key = this.watchService.take())) == null) {
                        ConsoleLogger.warn("Received watch event for unknown directory key");
                        continue;
                    }
                    boolean shouldRestart = false;
                    int eventCount = 0;
                    int skippedEventCount = 0;
                    int processedFiles = 0;
                    int convertedFiles = 0;
                    StringBuilder eventSummary = new StringBuilder();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        ++eventCount;
                        WatchEvent.Kind<?> kind = event.kind();
                        Path changedFile = dir.resolve((Path)event.context()).toAbsolutePath();
                        if (this.isTemporaryFile(changedFile)) {
                            ++skippedEventCount;
                            continue;
                        }
                        eventSummary.append(changedFile.getFileName()).append(" (").append(kind.name()).append("), ");
                        boolean isYamlFile = changedFile.toString().toLowerCase().endsWith(".yml");
                        if (isYamlFile && this.otelConfigPath.getParent().equals(changedFile.getParent()) && (kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_CREATE)) {
                            ++processedFiles;
                            shouldRestart = true;
                            boolean converted = DirectoryWatcher.convertWindowsPathsToUnix(changedFile);
                            if (converted || changedFile.equals(this.otelConfigPath)) {
                                ++convertedFiles;
                            }
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !changedFile.equals(this.muleAgentJksPath)) continue;
                        ConsoleLogger.info("JKS certificate file modified: " + changedFile);
                        this.certificateProcessor.processCertificates();
                        shouldRestart = true;
                    }
                    String events = eventSummary.toString();
                    if (events.endsWith(", ")) {
                        events = events.substring(0, events.length() - 2);
                    }
                    if (!(valid = key.reset())) {
                        ConsoleLogger.warn("Watch key is no longer valid, stopping monitoring for: " + dir);
                        break block3;
                    }
                    if (shouldRestart) {
                        ConsoleLogger.info("Restart-qualifying changes detected. Queueing restart.");
                        ConsoleLogger.debug("Event summary: " + events);
                        this.queueRestart();
                        continue;
                    }
                    ConsoleLogger.info("No restart-qualifying changes detected. No restart queued.");
                }
            }
            catch (InterruptedException e) {
                ConsoleLogger.error("Directory watching interrupted: " + e.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                ConsoleLogger.error("Unexpected error in watch loop: " + e.getMessage());
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        this.shutdownRequested = true;
        if (!this.restartScheduler.isShutdown()) {
            ConsoleLogger.info("Shutting down restart scheduler...");
            this.restartScheduler.shutdown();
            try {
                if (!this.restartScheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                    ConsoleLogger.warn("Restart scheduler did not terminate gracefully, forcing shutdown");
                    this.restartScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                ConsoleLogger.error("Interrupted while waiting for restart scheduler shutdown");
                this.restartScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.watchService != null) {
            this.watchService.close();
        }
    }

    private void performRestart() {
        try {
            String[] restartCommand;
            String scriptPath;
            String muleHome = System.getProperty("muleHome");
            if (muleHome == null) {
                System.err.println("muleHome system property is not set.");
                return;
            }
            if (isWindows) {
                scriptPath = muleHome + "\\am\\bin\\am.ps1";
                restartCommand = new String[]{"powershell", "-ExecutionPolicy", "Bypass", "-File", scriptPath, "restart", "-OtelOnly"};
            } else {
                scriptPath = muleHome + "/am/bin/am restart-otel";
                restartCommand = new String[]{"sh", "-c", scriptPath};
            }
            ProcessBuilder processBuilder = new ProcessBuilder(restartCommand);
            processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(Paths.get(muleHome, "am", "logs", "directorywatcher.err").toFile()));
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(Paths.get(muleHome, "am", "logs", "directorywatcher.log").toFile()));
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                boolean isRunning = this.isOtelCollectorRunning();
                if (!isRunning) {
                    System.err.println("RESTART FAILED: OTEL Collector not running after restart");
                }
            } else {
                System.err.println("RESTART FAILED: Exit code " + exitCode);
            }
        }
        catch (Exception e) {
            System.err.println("Error during OpenTelemetry Collector restart: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private void queueRestart() {
        if (this.restartScheduler.isShutdown()) {
            ConsoleLogger.warn("Restart request ignored - scheduler is already shutdown");
            return;
        }
        int currentCount = this.pendingRestartCount.incrementAndGet();
        if (this.restartScheduled.compareAndSet(false, true)) {
            ConsoleLogger.info("RESTART SCHEDULED: " + currentCount + " requests queued, executing in " + 15 + "s");
            this.restartScheduler.schedule(() -> {
                try {
                    if (!this.shutdownRequested) {
                        int finalCount = this.pendingRestartCount.get();
                        ConsoleLogger.info("RESTART EXECUTING: " + finalCount + " requests after " + 15 + "s debounce");
                        this.performRestart();
                        this.pendingRestartCount.set(0);
                        ConsoleLogger.info("RESTART COMPLETED: OTEL Collector restarted successfully");
                    }
                }
                catch (Exception e) {
                    ConsoleLogger.error("RESTART FAILED: " + e.getMessage());
                    e.printStackTrace(System.err);
                }
                finally {
                    this.restartScheduled.set(false);
                }
            }, 15L, TimeUnit.SECONDS);
        }
    }

    private void restartCollector() {
        this.queueRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOtelCollectorRunning() throws IOException {
        try (BufferedReader reader = null;){
            String line;
            CharSequence[] processSearchCommand;
            String muleHome = System.getProperty("muleHome");
            if (muleHome == null) {
                ConsoleLogger.error("muleHome system property is not set.");
                boolean bl = false;
                return bl;
            }
            if (isWindows) {
                String scriptPath = muleHome + "\\am\\bin\\am.ps1";
                processSearchCommand = new String[]{"powershell", "-ExecutionPolicy", "Bypass", "-File", scriptPath, "status"};
            } else {
                String psGrepCommand = "ps aux | grep otel-collector | grep -v grep";
                processSearchCommand = new String[]{"sh", "-c", psGrepCommand};
            }
            ConsoleLogger.debug("Looking for otel-collector process by running : " + String.join((CharSequence)" ", processSearchCommand));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])processSearchCommand);
            Process process = processBuilder.start();
            if (isWindows) {
                int exitCode = process.waitFor();
                boolean bl = exitCode == 0;
                return bl;
            }
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("otel")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void main(String[] args) {
        try {
            DirectoryWatcher watcher = new DirectoryWatcher();
            watcher.watch();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

