/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.country;

import com.mulesoft.analytics.collector.country.CountryLookup;
import com.mulesoft.analytics.collector.shaded.db.CHMCache;
import com.mulesoft.analytics.collector.shaded.geoip2.DatabaseReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CountryLookupImpl
implements CountryLookup {
    private static final Logger LOGGER = LogManager.getLogger(CountryLookupImpl.class);
    private final DatabaseReader db;

    public CountryLookupImpl(File databaseFile) throws IOException {
        this.db = new DatabaseReader.Builder(new GZIPInputStream(new FileInputStream(databaseFile))).withCache(new CHMCache()).build();
    }

    @Override
    @Nullable
    public String country(@Nullable String address) {
        try {
            return this.db.country(InetAddress.getByName(address)).getCountry().getIsoCode();
        }
        catch (Exception e) {
            LOGGER.debug("Country code lookup failed", (Throwable)e);
            return null;
        }
    }
}

