/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mulesoft.analytics.collector.metrics.BatcherSettings;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import java.util.HashSet;

public class Metrics {
    public static final String INBOUND_METRIC_NAME = "app_inbound_metric";
    public static final String OUTBOUND_METRIC_NAME = "app_outbound_metric";
    public static final String APPSTATS_METRIC_NAME = "app_stats";
    public static final String CUSTOM_METRIC_NAME = "custom_metric";
    public static final String API_RAW_METRIC_NAME = "api_raw_metric";
    public static final String API_SUMMARY_METRIC_NAME = "api_summary_metric";
    public static final String API_CLIENT_IP_METRIC_NAME = "api_client_ip_metric";
    public static final String API_PATH_METRIC_NAME = "api_path_metric";
    public static final String API_COUNTRY_METRIC_NAME = "api_country_metric";
    public static final String SYSTEM_METRIC_NAME = "system_metric";
    public static final String PAYLOADSTATS_METRIC_NAME = "payload_stats";
    public static final String MULESTATS_METRIC_NAME = "mule_stats";
    public static final String CORE_PRICING_METRIC_NAME = "core_pricing";
    public static final String FLOW_ID_TAG = "flow_id";
    public static final String ENDPOINT_TYPE_TAG = "endpoint_type";
    public static final String RESPONSE_TYPE_TAG = "response_type";
    public static final String ID_TAG = "id";
    public static final String APP_ID_TAG = "app_id";
    public static final String ASSET_ID_TAG = "asset_id";
    public static final String MASTER_ORG_ID_TAG = "master_org_id";
    public static final String ORG_ID_TAG = "org_id";
    public static final String ENV_ID_TAG = "env_id";
    public static final String CLUSTER_ID_TAG = "cluster_id";
    public static final String SERVER_ID_TAG = "server_id";
    public static final String WORKER_ID_TAG = "worker_id";
    public static final String PROTOCOL_TAG = "protocol";
    public static final String CLIENT_ID_TAG = "client_id";
    public static final String CLIENT_APP_TAG = "client_app";
    public static final String REMOTE_HOST_TAG = "remote_host";
    public static final String REMOTE_PORT_TAG = "remote_port";
    public static final String ENDPOINT_TAG = "endpoint";
    public static final String OPERATION_TAG = "operation";
    public static final String HOST_HEADER_TAG = "host_header";
    public static final String SOURCE_HASH_TAG = "source_hash";
    public static final String DEPLOYMENT_TYPE_TAG = "deployment_type";
    public static final String DEPLOYMENT_HASH_TAG = "deployment_hash";
    public static final String PUBLIC_IP_TAG = "public_ip";
    public static final String IS_PRODUCTION = "is_prod";
    public static final String METRIC_NAME_TAG = "metric_name";
    public static final String FACTS_FIELD = "facts";
    public static final String MESSAGE_ID_TAG = "message_id";
    public static final String HTTP_PATH_TAG = "path";
    public static final String HTTP_METHOD_TAG = "method";
    public static final String USER_AGENT_TAG = "user_agent";
    public static final String STATUS_CODE_TAG = "status_code";
    public static final String API_ID_TAG = "api_id";
    public static final String API_VERSION_ID_TAG = "api_version_id";
    public static final String API_NAME_TAG = "api_name";
    public static final String API_VERSION_TAG = "api_version";
    public static final String API_INSTANCE_LABEL_TAG = "api_instance_label";
    public static final String POLICY_ID_TAG = "policy_id";
    public static final String POLICY_NAME_TAG = "policy_name";
    public static final String POLICY_OUTCOME_TAG = "policy_outcome";
    public static final String POLICY_VIOLATION_TAG = "policy_violation";
    public static final String REQUEST_DISPOSITION_TAG = "request_disposition";
    public static final String COUNTRY_TAG = "country";
    public static final String EVENT_TIME_FIELD = "_time";
    public static final String RESPONSE_TIME_FIELD = "response_time";
    public static final String RESPONSE_TIME = "responseTime";
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String MESSAGE_COUNT_FIELD = "messageCount";
    public static final String ERROR_COUNT_FIELD = "errorCount";
    public static final String AVG_RESPONSE_TIME_FIELD = "avg_response_time";
    public static final String RESPONSE_TIME_COUNT_FIELD = "response_time.count";
    public static final String AVG_REQUEST_COUNT_FIELD = "avg_request_count";
    public static final String REQUEST_SIZE_FIELD = "request_size";
    public static final String RESPONSE_SIZE_FIELD = "response_size";
    public static final String API_LIST_TAG = "api_ids";
    public static final String MULE_VERSION_TAG = "mule_ver";
    public static final String COLLECTOR_VERSION_TAG = "ua_ver";
    public static final String APP_SESSION_TAG = "app_session";
    public static final String PAYLOAD_COMPONENT_TYPE_TAG = "component";
    public static final String PAYLOAD_COMPONENT_LOCATION_TAG = "location";
    public static final String PAYLOAD_INVOCATION_COUNT_FIELD = "invocation_count";
    public static final String PAYLOAD_INPUT_COUNT_FIELD = "input_count";
    public static final String PAYLOAD_OUTPUT_COUNT_FIELD = "output_count";
    public static final String PAYLOAD_INPUT_SIZE_FIELD = "input_size";
    public static final String PAYLOAD_OUTPUT_SIZE_FIELD = "output_size";
    public static final String MULESTATS_MESSAGE_COUNT_FIELD = "message_count";
    public static final String MULESTATS_ERROR_COUNT_FIELD = "error_count";
    public static final String CORE_PRICING_STATS_USAGE_COUNT_FIELD = "usage_count";
    public static final String CORE_PRICING_STATS_PUBLIC_USAGE_COUNT = "public_usage_count";
    public static final String CORE_PRICING_STATS_FLOW_COUNT = "flow_count";
    public static final String CORE_PRICING_STATS_FLOW_COUNT_PILOT = "flow_count_pilot";
    public static final String CORE_PRICING_BILLABLE = "billable";
    public static final String AVAILABLE_PROCESSORS = "available_processors";
    public static final String CPU = "cpu";
    public static final String POD_CPU_VAR = "pod_cpu";
    public static final String POD_CPU_LIMIT_VAR = "pod_cpu_limit";
    public static final String POD_CPU_REQUEST_VAR = "pod_cpu_request";
    public static final String LOAD_AVERAGE = "load_average";
    public static final String TOTAL_PHYSICAL_MEMORY_SIZE = "total_physical_memory_size";
    public static final String CLASSES_LOADED = "classes_loaded";
    public static final String CLASSES_LOADED_TOTAL = "classes_loaded_total";
    public static final String CLASSES_UNLOADED = "classes_unloaded";
    public static final String COMMITTED_MEMORY = "committed_memory";
    public static final String GCG1_OLD_GENERATION_COLLECTION_COUNT = "gc_g1_old_generation_collection_count";
    public static final String GCG1_OLD_GENERATION_COLLECTION_TIME = "gc_g1_old_generation_collection_time";
    public static final String GCG1_YOUNG_GENERATION_COLLECTION_COUNT = "gc_g1_young_generation_collection_count";
    public static final String GCG1_YOUNG_GENERATION_COLLECTION_TIME = "gc_g1_young_generation_collection_time";
    public static final String GCG1_MARKSWEEP_COLLECTION_COUNT = "gc_marksweep_collection_count";
    public static final String GCG1_MARKSWEEP_COLLECTION_TIME = "gc_marksweep_collection_time";
    public static final String GC_PARNEW_COLLECTION_COUNT = "gc_parnew_collection_count";
    public static final String GC_PARNEW_COLLECTION_TIME = "gc_parnew_collection_time";
    public static final String HEAP_COMMITTED = "heap_committed";
    public static final String HEAP_TOTAL = "heap_total";
    public static final String HEAP_USED = "heap_used";
    public static final String INIT_MEMORY = "init_memory";
    public static final String JAVA_UPTIME = "jvm_uptime";
    public static final String MAX_MEMORY = "max_memory";
    public static final String THREAD_COUNT = "thread_count";
    public static final String USED_MEMORY = "used_memory";
    public static final String COMMITTED_VIRTUAL_MEMORY_SIZE = "commited_virtual_memory_size";
    public static final String FREE_PHYSICAL_MEMORY_SIZE = "free_physical_memory_size";
    public static final String FREE_SWAP_SPACE_SIZE = "free_swap_space_size";
    public static final String PROCESS_CPU_LOAD = "process_cpu_load";
    public static final String PROCESS_CPU_TIME = "process_cpu_time";
    public static final String SYSTEM_CPU_LOAD = "system_cpu_load";
    public static final String SYSTEM_LOAD_AVERAGE = "system_load_average";
    public static final String TOTAL_SWAP_SPACE_SIZE = "total_swap_space_size";
    public static final FactMeta INBOUND_INVOCATION = new FactMeta.Builder("app_inbound_metric").addRetainingDimension("flow_id").addRetainingDimension("endpoint_type").addRetainingDimension("response_type").addRetainingDimension("protocol").addRetainingDimension("host_header").addRetainingDimension("source_hash").addCollapsibleDimension("client_id").addCollapsibleDimension("remote_host").addCollapsibleDimension("endpoint").addCollapsibleDimension("operation").addLongMetric("response_time").addLongMetric("avg_response_time").addLongMetric("avg_request_count").build();
    public static final FactMeta OUTBOUND_INVOCATION = new FactMeta.Builder("app_outbound_metric").addRetainingDimension("flow_id").addRetainingDimension("endpoint_type").addRetainingDimension("response_type").addRetainingDimension("protocol").addRetainingDimension("remote_port").addCollapsibleDimension("remote_host").addCollapsibleDimension("endpoint").addCollapsibleDimension("operation").addLongMetric("response_time").addLongMetric("avg_response_time").addLongMetric("avg_request_count").build();
    public static final FactMeta API_RAW_METRIC = Metrics.apiMetricsBaseBuilder("api_raw_metric").addRetainingDimension("path").addRetainingDimension("user_agent").addRetainingDimension("client_app").addRetainingDimension("remote_host").addRetainingDimension("api_instance_label").addRetainingDimension("country").addRetainingDimension("message_id").addLongMetric("_time").build();
    public static final FactMeta API_SUMMARY_METRIC = Metrics.apiMetricsBaseBuilder("api_summary_metric").build();
    public static final FactMeta API_CLIENT_IP_METRIC = Metrics.apiMetricsBaseBuilder("api_client_ip_metric").addCollapsibleDimension("remote_host").build();
    public static final FactMeta API_PATH_METRIC = Metrics.apiMetricsBaseBuilder("api_path_metric").addCollapsibleDimension("path").build();
    public static final FactMeta API_COUNTRY_METRIC = Metrics.apiMetricsBaseBuilder("api_country_metric").addCollapsibleDimension("country").build();
    public static final FactMeta SYSTEM_METRIC = Metrics.systemMetricsBaseBuilder().addLongMetric("_time").build();
    public static final FactMeta PAYLOAD_STATS_METRIC = new FactMeta.Builder("payload_stats").addRetainingDimension("app_id").addRetainingDimension("app_session").addRetainingDimension("component").addRetainingDimension("location").addLongMetric("invocation_count").addLongMetric("input_count").addLongMetric("output_count").addLongMetric("input_size").addLongMetric("output_size").build();
    public static final FactMeta MULE_STATS_METRIC = new FactMeta.Builder("mule_stats").addRetainingDimension("app_id").addRetainingDimension("app_session").addLongMetric("message_count").addLongMetric("error_count").build();
    public static final FactMeta CORE_PRICING_STATS_METRIC = new FactMeta.Builder("core_pricing").addRetainingDimension("id").addRetainingDimension("master_org_id").addRetainingDimension("org_id").addRetainingDimension("env_id").addRetainingDimension("asset_id").addRetainingDimension("worker_id").addLongMetric("timestamp").addLongMetric("usage_count").addLongMetric("flow_count").addLongMetric("flow_count_pilot").build();
    public static final FactMeta APP_STATS_METRIC = new FactMeta.Builder("app_stats").addRetainingDimension("public_ip").addRetainingDimension("mule_ver").addRetainingDimension("ua_ver").addRetainingDimension("deployment_hash").addRetainingDimension("api_ids").addLongMetric("messageCount").addLongMetric("errorCount").addLongMetric("responseTime").addLongMetric("_time").build();
    public static final ImmutableMap<String, BatcherSettings> BATCHER_SETTINGS_MAP = ImmutableMap.builder().put((Object)"api_raw_metric", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id", "api_id", "api_version_id"}), Sets.newHashSet((Object[])new String[]{"api_version_id"}))).put((Object)"api_summary_metric", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id", "api_id", "api_version_id"}), Sets.newHashSet((Object[])new String[]{"api_version_id"}))).put((Object)"api_client_ip_metric", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id", "api_id", "api_version_id"}), Sets.newHashSet((Object[])new String[]{"api_version_id"}))).put((Object)"api_path_metric", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id", "api_id", "api_version_id"}), Sets.newHashSet((Object[])new String[]{"api_version_id"}))).put((Object)"api_country_metric", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id", "api_id", "api_version_id"}), Sets.newHashSet((Object[])new String[]{"api_version_id"}))).put((Object)"system_metric", (Object)new BatcherSettings(false, new HashSet<String>(), new HashSet<String>())).put((Object)"custom_metric", (Object)new BatcherSettings(true, Sets.newHashSet((Object[])new String[]{"metric_name", "app_id"}), new HashSet<String>())).put((Object)"payload_stats", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id", "app_session"}), new HashSet<String>())).put((Object)"app_inbound_metric", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id"}), new HashSet<String>())).put((Object)"app_outbound_metric", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id"}), new HashSet<String>())).put((Object)"app_stats", (Object)new BatcherSettings(false, Sets.newHashSet((Object[])new String[]{"app_id"}), new HashSet<String>())).build();
    private static final ImmutableSet<String> OUTBOUND_EXCLUDES = ImmutableSet.of((Object)"Apikit", (Object)"Apikit-soap", (Object)"Extension", (Object)"Scripting", (Object)"Signature", (Object)"Json", (Object[])new String[]{"Xml", "Proxy", "Vm", "Raml-validator", "Validation", "Java", "Generated", "Json-logger", "Min-log", "Jsonloggermodule", "Security", "Cors", "Processors", "Xml-module", "Compression", "Custom-metrics"});

    private Metrics() {
    }

    public static boolean shouldExclude(String type) {
        return OUTBOUND_EXCLUDES.contains((Object)type);
    }

    private static FactMeta.Builder apiMetricsBaseBuilder(String name) {
        return new FactMeta.Builder(name).addRetainingDimension(DEPLOYMENT_TYPE_TAG).addRetainingDimension(ORG_ID_TAG).addRetainingDimension(ENV_ID_TAG).addRetainingDimension(WORKER_ID_TAG).addRetainingDimension(CLUSTER_ID_TAG).addRetainingDimension(SERVER_ID_TAG).addRetainingDimension(PUBLIC_IP_TAG).addRetainingDimension(API_ID_TAG).addRetainingDimension(API_VERSION_ID_TAG).addRetainingDimension(API_NAME_TAG).addRetainingDimension(API_VERSION_TAG).addRetainingDimension(POLICY_ID_TAG).addRetainingDimension(POLICY_NAME_TAG).addRetainingDimension(POLICY_VIOLATION_TAG).addRetainingDimension(REQUEST_DISPOSITION_TAG).addRetainingDimension(HTTP_METHOD_TAG).addRetainingDimension(STATUS_CODE_TAG).addRetainingDimension(CLIENT_ID_TAG).addRetainingDimension(APP_ID_TAG).addRetainingDimension(FLOW_ID_TAG).addLongMetric(RESPONSE_TIME_FIELD).addLongMetric(RESPONSE_SIZE_FIELD).addLongMetric(REQUEST_SIZE_FIELD);
    }

    private static FactMeta.Builder systemMetricsBaseBuilder() {
        return new FactMeta.Builder(SYSTEM_METRIC_NAME).addRetainingDimension(METRIC_NAME_TAG).addLongMetric(AVAILABLE_PROCESSORS).addLongMetric(CLASSES_LOADED).addLongMetric(CLASSES_LOADED_TOTAL).addLongMetric(CLASSES_UNLOADED).addLongMetric(COMMITTED_VIRTUAL_MEMORY_SIZE).addLongMetric(COMMITTED_MEMORY).addLongMetric(FREE_PHYSICAL_MEMORY_SIZE).addLongMetric(FREE_SWAP_SPACE_SIZE).addLongMetric(GCG1_MARKSWEEP_COLLECTION_COUNT).addLongMetric(GCG1_MARKSWEEP_COLLECTION_TIME).addLongMetric(GC_PARNEW_COLLECTION_COUNT).addLongMetric(GC_PARNEW_COLLECTION_TIME).addLongMetric(HEAP_COMMITTED).addLongMetric(HEAP_TOTAL).addLongMetric(HEAP_USED).addLongMetric(INIT_MEMORY).addLongMetric(JAVA_UPTIME).addLongMetric(MAX_MEMORY).addLongMetric(PROCESS_CPU_TIME).addLongMetric(THREAD_COUNT).addLongMetric(TOTAL_PHYSICAL_MEMORY_SIZE).addLongMetric(TOTAL_SWAP_SPACE_SIZE).addLongMetric(USED_MEMORY).addDoubleMetric(CPU).addDoubleMetric(POD_CPU_VAR).addDoubleMetric(POD_CPU_LIMIT_VAR).addDoubleMetric(POD_CPU_REQUEST_VAR).addDoubleMetric(LOAD_AVERAGE).addDoubleMetric(GCG1_OLD_GENERATION_COLLECTION_COUNT).addDoubleMetric(GCG1_OLD_GENERATION_COLLECTION_TIME).addDoubleMetric(GCG1_YOUNG_GENERATION_COLLECTION_COUNT).addDoubleMetric(GCG1_YOUNG_GENERATION_COLLECTION_TIME).addDoubleMetric(PROCESS_CPU_LOAD).addDoubleMetric(SYSTEM_CPU_LOAD).addDoubleMetric(SYSTEM_LOAD_AVERAGE);
    }

    public static FactMeta.Builder customMetricsBaseBuilder(String name) {
        return new FactMeta.Builder(name).addRetainingDimension(METRIC_NAME_TAG).addRetainingDimension(IS_PRODUCTION).addRetainingDimension(FACTS_FIELD);
    }
}

