/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.AsyncProcessor;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventCollector;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduledReducer<I, O>
extends Step<I, O> {
    private static final Logger LOGGER = LogManager.getLogger(AsyncProcessor.class);
    @Nullable
    protected EventCollector<I, O> collector;
    @Nullable
    protected EventProducer<O> optionalPostProducer;
    @Nullable
    private Future<?> scheduledTask;
    private final ScheduledExecutorService executor;
    private final long delay;
    private final long period;

    public ScheduledReducer(ScheduledExecutorService executor, long period) {
        this(executor, 0L, period);
    }

    public ScheduledReducer(ScheduledExecutorService executor, long delay, long period) {
        this.executor = executor;
        this.delay = delay;
        this.period = period;
    }

    @Override
    protected void process(Event<I> event) {
        if (this.collector != null) {
            this.collector.add(event);
        }
    }

    @Override
    public void start() {
        this.scheduledTask = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (ScheduledReducer.this.collector == null) {
                    return;
                }
                try {
                    Collection aggregatedEvents = ScheduledReducer.this.collector.collect();
                    if (ScheduledReducer.this.optionalPostProducer != null) {
                        aggregatedEvents = new ArrayList(aggregatedEvents);
                        aggregatedEvents.addAll(ScheduledReducer.this.optionalPostProducer.produce());
                    }
                    for (Event event : aggregatedEvents) {
                        ScheduledReducer.this.nextProcess(event);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception inside ScheduledAggregationStep thread", (Throwable)e);
                }
            }
        }, this.delay, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
            this.scheduledTask = null;
        }
    }
}

