/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.strategy.sampling;

import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.data.NonAggregatedResult;
import com.mulesoft.analytics.limiter.strategy.EventLimiterStrategy;
import com.mulesoft.analytics.limiter.strategy.StrategyState;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SamplingStrategy
implements EventLimiterStrategy {
    private static final Random rand = new Random();
    private StrategyState currentState;
    private EventProcessorConfig config;
    private int eventCount;
    private List<UserEvent> allEvents;

    public SamplingStrategy(EventProcessorConfig config) {
        this.configure(config);
        this.currentState = StrategyState.COLLECTING_SAMPLES;
        this.allEvents = new ArrayList<UserEvent>();
    }

    @Override
    public StrategyType getType() {
        return StrategyType.RANDOM_SAMPLING;
    }

    @Override
    public void configure(EventProcessorConfig config) {
        this.config = config;
    }

    @Override
    public boolean isLimiting() {
        return true;
    }

    @Override
    public boolean isAggregating() {
        return false;
    }

    @Override
    public void begin() {
        this.eventCount = 0;
        this.allEvents = new ArrayList<UserEvent>();
    }

    @Override
    public StrategyState getState() {
        return this.currentState;
    }

    @Override
    public void append(UserEvent event) {
        int evictIndex;
        ++this.eventCount;
        if (this.currentState == StrategyState.FINISHED_COLLECTING) {
            throw new IllegalStateException("Cannot add more events. Strategy is in end() state.");
        }
        if (this.currentState == StrategyState.COLLECTING_SAMPLES) {
            this.allEvents.add(event);
        } else if (this.currentState == StrategyState.APPLYING_LIMIT && (evictIndex = rand.nextInt(this.eventCount)) < this.allEvents.size()) {
            this.allEvents.set(evictIndex, event);
        }
    }

    @Override
    public int getBufferSize() {
        return this.allEvents.size();
    }

    @Override
    public void learn() {
        this.currentState = StrategyState.APPLYING_LIMIT;
    }

    @Override
    public void end() {
        this.currentState = StrategyState.FINISHED_COLLECTING;
    }

    @Override
    public EventLimiterResult getResults() {
        return new NonAggregatedResult(this.allEvents, this.config, this.currentState);
    }

    @Override
    public String getLearningInfo() {
        return null;
    }

    @Override
    public String getSamplingInfo() {
        return null;
    }

    @Override
    public String getOtherInfo() {
        return null;
    }
}

