/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.util.Strings;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@Singleton
class JMXMetricParser {
    @Inject
    private Configuration configuration;
    private volatile long lastSeenXmxBytes = -1L;
    private static Map<String, String> knownCategories = new HashMap<String, String>();
    private static Map<String, String> translations = new HashMap<String, String>();
    private static List<String> skipCategories = new ArrayList<String>();
    private static final String EQUALS = "=";
    private static final String PART_SEPARATOR = ":";
    private static final String DOT = ".";
    private static final String JVM = "jvm";
    private static final String MEMORY = "jvm.memory";

    JMXMetricParser() {
    }

    @Nullable
    public MetricRecord parse(String metricName, Object value, List<Tuple<String, String>> tags) {
        if (StringUtils.startsWith((CharSequence)metricName, (CharSequence)"jvm.arguments.")) {
            ArrayList<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
            String arg = metricName.substring("jvm.arguments.".length());
            if (!arg.isEmpty()) {
                String fieldName = Strings.normalize(Strings.toCamelCase(arg));
                String stringValue = value.toString();
                this.cacheXmxIfPresent(fieldName, stringValue);
                stringValue = this.substituteHeapTotalIfEnabled(fieldName, stringValue);
                values.add(Tuple.tuple(fieldName, stringValue));
                return MetricRecord.create(Strings.normalize(Strings.toCamelCase("jvm.arguments")), tags, values);
            }
        }
        boolean isMbeanName = metricName.contains(",");
        ArrayList<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
        StringBuilder name = new StringBuilder();
        if (isMbeanName) {
            String valuePart;
            String[] parts = metricName.split(",");
            String[] typeParts = parts[0].split(EQUALS);
            if (typeParts.length < 2) {
                return null;
            }
            String metricPartName = typeParts[1];
            if (skipCategories.contains(metricPartName.toLowerCase())) {
                return null;
            }
            name.append(this.appendCategory(metricPartName));
            if (parts.length > 1) {
                int indexOfName = parts[1].indexOf(EQUALS);
                if (indexOfName > 0 && parts[1].length() >= 5) {
                    String[] valueParts = parts[1].substring(5).split(PART_SEPARATOR);
                    if (valueParts.length < 2) {
                        return null;
                    }
                    name.append(DOT).append(JMXMetricParser.translate(valueParts[0]));
                    valuePart = JMXMetricParser.translate(valueParts[1]);
                } else {
                    valuePart = parts[1];
                }
            } else {
                valuePart = "value";
            }
            String normalizedField = Strings.normalize(Strings.toCamelCase(valuePart));
            String stringValue = this.substituteHeapTotalIfEnabled(normalizedField, value.toString());
            values.add(Tuple.tuple(normalizedField, stringValue));
        } else {
            String[] valueParts;
            String partialName = metricName;
            if (metricName.contains("java.lang:type=")) {
                int idx = metricName.indexOf("java.lang:type=");
                partialName = metricName.substring(idx + 15);
            }
            if ((valueParts = partialName.split(PART_SEPARATOR)).length < 2) {
                return null;
            }
            String metricNamePart = valueParts[0];
            if (skipCategories.contains(metricNamePart.toLowerCase())) {
                return null;
            }
            name.append(this.appendCategory(metricNamePart));
            String normalizedField = Strings.normalize(Strings.toCamelCase(valueParts[1]));
            String stringValue = this.substituteHeapTotalIfEnabled(normalizedField, value.toString());
            values.add(Tuple.tuple(normalizedField, stringValue));
        }
        return MetricRecord.create(Strings.normalize(Strings.toCamelCase(name.toString())), tags, values);
    }

    private void cacheXmxIfPresent(String fieldName, String stringValue) {
        long parsed;
        if ("xmx".equals(fieldName) && (parsed = NumberUtils.toLong((String)stringValue, (long)-1L)) != -1L) {
            this.lastSeenXmxBytes = parsed;
        }
    }

    private String substituteHeapTotalIfEnabled(String fieldName, String originalValue) {
        if ("heap_total".equals(fieldName) && this.configuration.isJvmHeapTotalToXmxEnabled() && this.lastSeenXmxBytes != -1L) {
            return String.valueOf(this.lastSeenXmxBytes);
        }
        return originalValue;
    }

    private String appendCategory(String metricName) {
        String m3name = JMXMetricParser.translate(metricName);
        if (knownCategories.containsKey(m3name.toLowerCase())) {
            return knownCategories.get(m3name.toLowerCase()) + DOT + m3name;
        }
        return metricName;
    }

    private static String translate(String val) {
        String lv = val.toLowerCase();
        return translations.containsKey(lv) ? translations.get(lv) : val;
    }

    static {
        skipCategories.add("memorypool");
        knownCategories.put("par eden space", MEMORY);
        knownCategories.put("ps eden space", MEMORY);
        knownCategories.put("metaspace", MEMORY);
        knownCategories.put("par survivor space", MEMORY);
        knownCategories.put("ps survivor space", MEMORY);
        knownCategories.put("code cache", MEMORY);
        knownCategories.put("compressed class space", MEMORY);
        knownCategories.put("tenured gen", MEMORY);
        knownCategories.put("ps old gen", MEMORY);
        knownCategories.put("operatingsystem", "jvm.cpu");
        knownCategories.put("classloading", JVM);
        knownCategories.put("threading", JVM);
        knownCategories.put("memory", JVM);
        knownCategories.put("runtime", JVM);
        knownCategories.put("garbagecollector", JVM);
        translations.put("ps eden space", "par eden space");
        translations.put("ps survivor space", "par survivor space");
        translations.put("ps old gen", "tenured gen");
        translations.put("ps marksweep", "marksweepcompact");
        translations.put("gc ps marksweep collection count", "gc markSweep collection count");
        translations.put("gc ps marksweep collection time", "gc markSweep collection time");
        translations.put("ps scavenge", "parnew");
        translations.put("gc ps scavenge collection count", "gc par new collection count");
        translations.put("gc ps scavenge collection time", "gc par new collection time");
    }
}

