/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.djb;

import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECFieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.djb.Curve25519Field;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.raw.Nat256;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class Curve25519FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = Nat256.toBigInteger((int[])Curve25519Field.P);
    private static final int[] PRECOMP_POW2 = new int[]{1242472624, -991028441, -1389370248, 792926214, 1039914919, 726466713, 1338105611, 730014848};
    protected int[] x;

    public Curve25519FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for Curve25519FieldElement");
        }
        this.x = Curve25519Field.fromBigInteger((BigInteger)bigInteger);
    }

    public Curve25519FieldElement() {
        this.x = Nat256.create();
    }

    protected Curve25519FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero((int[])this.x);
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne((int[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat256.getBit((int[])this.x, (int)0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger((int[])this.x);
    }

    @Override
    public String getFieldName() {
        return "Curve25519Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        Curve25519Field.add((int[])this.x, (int[])((Curve25519FieldElement)eCFieldElement).x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat256.create();
        Curve25519Field.addOne((int[])this.x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        Curve25519Field.subtract((int[])this.x, (int[])((Curve25519FieldElement)eCFieldElement).x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        Curve25519Field.multiply((int[])this.x, (int[])((Curve25519FieldElement)eCFieldElement).x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        Curve25519Field.inv((int[])((Curve25519FieldElement)eCFieldElement).x, (int[])nArray);
        Curve25519Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat256.create();
        Curve25519Field.negate((int[])this.x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat256.create();
        Curve25519Field.square((int[])this.x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat256.create();
        Curve25519Field.inv((int[])this.x, (int[])nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat256.isZero((int[])nArray) || Nat256.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat256.create();
        Curve25519Field.square((int[])nArray, (int[])nArray2);
        Curve25519Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = nArray2;
        Curve25519Field.square((int[])nArray2, (int[])nArray3);
        Curve25519Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3);
        int[] nArray4 = Nat256.create();
        Curve25519Field.square((int[])nArray3, (int[])nArray4);
        Curve25519Field.multiply((int[])nArray4, (int[])nArray, (int[])nArray4);
        int[] nArray5 = Nat256.create();
        Curve25519Field.squareN((int[])nArray4, (int)3, (int[])nArray5);
        Curve25519Field.multiply((int[])nArray5, (int[])nArray3, (int[])nArray5);
        int[] nArray6 = nArray3;
        Curve25519Field.squareN((int[])nArray5, (int)4, (int[])nArray6);
        Curve25519Field.multiply((int[])nArray6, (int[])nArray4, (int[])nArray6);
        int[] nArray7 = nArray5;
        Curve25519Field.squareN((int[])nArray6, (int)4, (int[])nArray7);
        Curve25519Field.multiply((int[])nArray7, (int[])nArray4, (int[])nArray7);
        int[] nArray8 = nArray4;
        Curve25519Field.squareN((int[])nArray7, (int)15, (int[])nArray8);
        Curve25519Field.multiply((int[])nArray8, (int[])nArray7, (int[])nArray8);
        int[] nArray9 = nArray7;
        Curve25519Field.squareN((int[])nArray8, (int)30, (int[])nArray9);
        Curve25519Field.multiply((int[])nArray9, (int[])nArray8, (int[])nArray9);
        int[] nArray10 = nArray8;
        Curve25519Field.squareN((int[])nArray9, (int)60, (int[])nArray10);
        Curve25519Field.multiply((int[])nArray10, (int[])nArray9, (int[])nArray10);
        int[] nArray11 = nArray9;
        Curve25519Field.squareN((int[])nArray10, (int)11, (int[])nArray11);
        Curve25519Field.multiply((int[])nArray11, (int[])nArray6, (int[])nArray11);
        int[] nArray12 = nArray6;
        Curve25519Field.squareN((int[])nArray11, (int)120, (int[])nArray12);
        Curve25519Field.multiply((int[])nArray12, (int[])nArray10, (int[])nArray12);
        int[] nArray13 = nArray12;
        Curve25519Field.square((int[])nArray13, (int[])nArray13);
        int[] nArray14 = nArray10;
        Curve25519Field.square((int[])nArray13, (int[])nArray14);
        if (Nat256.eq((int[])nArray, (int[])nArray14)) {
            return new Curve25519FieldElement(nArray13);
        }
        Curve25519Field.multiply((int[])nArray13, (int[])PRECOMP_POW2, (int[])nArray13);
        Curve25519Field.square((int[])nArray13, (int[])nArray14);
        if (Nat256.eq((int[])nArray, (int[])nArray14)) {
            return new Curve25519FieldElement(nArray13);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Curve25519FieldElement)) {
            return false;
        }
        Curve25519FieldElement curve25519FieldElement = (Curve25519FieldElement)object;
        return Nat256.eq((int[])this.x, (int[])curve25519FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 8);
    }
}

