/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1Encodable;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1EncodableVector;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1Set;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.DEROctetString;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.DERSequence;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.CMCEPrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.CMCEPublicKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.FalconPrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.FalconPublicKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.bike.BIKEParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.falcon.FalconParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.hqc.HQCParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.lms.Composer;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.saber.SABERParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.Utils;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.xmss.BDS;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Encodable;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Pack;
import java.io.IOException;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)asymmetricKeyParameter, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter, ASN1Set aSN1Set) throws IOException {
        if (asymmetricKeyParameter instanceof QTESLAPrivateKeyParameters) {
            QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters = (QTESLAPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID((int)qTESLAPrivateKeyParameters.getSecurityCategory());
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(qTESLAPrivateKeyParameters.getSecret()), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof SPHINCSPrivateKeyParameters) {
            SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters = (SPHINCSPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, (ASN1Encodable)new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID((String)sPHINCSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(sPHINCSPrivateKeyParameters.getKeyData()));
        }
        if (asymmetricKeyParameter instanceof NHPrivateKeyParameters) {
            NHPrivateKeyParameters nHPrivateKeyParameters = (NHPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = nHPrivateKeyParameters.getSecData();
            byte[] byArray = new byte[sArray.length * 2];
            for (int i = 0; i != sArray.length; ++i) {
                Pack.shortToLittleEndian(sArray[i], byArray, i * 2);
            }
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray));
        }
        if (asymmetricKeyParameter instanceof LMSPrivateKeyParameters) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters = (LMSPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = Composer.compose().u32str(1).bytes((Encodable)lMSPrivateKeyParameters).build();
            byte[] byArray2 = Composer.compose().u32str(1).bytes((Encodable)lMSPrivateKeyParameters.getPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set, byArray2);
        }
        if (asymmetricKeyParameter instanceof HSSPrivateKeyParameters) {
            HSSPrivateKeyParameters hSSPrivateKeyParameters = (HSSPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = Composer.compose().u32str(hSSPrivateKeyParameters.getL()).bytes((Encodable)hSSPrivateKeyParameters).build();
            byte[] byArray3 = Composer.compose().u32str(hSSPrivateKeyParameters.getL()).bytes((Encodable)hSSPrivateKeyParameters.getPublicKey().getLMSPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set, byArray3);
        }
        if (asymmetricKeyParameter instanceof SPHINCSPlusPrivateKeyParameters) {
            SPHINCSPlusPrivateKeyParameters sPHINCSPlusPrivateKeyParameters = (SPHINCSPlusPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.sphincsPlusOidLookup((SPHINCSPlusParameters)sPHINCSPlusPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(sPHINCSPlusPrivateKeyParameters.getEncoded()), aSN1Set, sPHINCSPlusPrivateKeyParameters.getPublicKey());
        }
        if (asymmetricKeyParameter instanceof SLHDSAPrivateKeyParameters) {
            SLHDSAPrivateKeyParameters sLHDSAPrivateKeyParameters = (SLHDSAPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.slhdsaOidLookup((SLHDSAParameters)sLHDSAPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, sLHDSAPrivateKeyParameters.getEncoded(), aSN1Set, sLHDSAPrivateKeyParameters.getPublicKey());
        }
        if (asymmetricKeyParameter instanceof PicnicPrivateKeyParameters) {
            PicnicPrivateKeyParameters picnicPrivateKeyParameters = (PicnicPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = picnicPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.picnicOidLookup((PicnicParameters)picnicPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof CMCEPrivateKeyParameters) {
            CMCEPrivateKeyParameters cMCEPrivateKeyParameters = (CMCEPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.mcElieceOidLookup((CMCEParameters)cMCEPrivateKeyParameters.getParameters()));
            CMCEPublicKey cMCEPublicKey = new CMCEPublicKey(cMCEPrivateKeyParameters.reconstructPublicKey());
            CMCEPrivateKey cMCEPrivateKey = new CMCEPrivateKey(0, cMCEPrivateKeyParameters.getDelta(), cMCEPrivateKeyParameters.getC(), cMCEPrivateKeyParameters.getG(), cMCEPrivateKeyParameters.getAlpha(), cMCEPrivateKeyParameters.getS(), cMCEPublicKey);
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)cMCEPrivateKey, aSN1Set);
        }
        if (asymmetricKeyParameter instanceof XMSSPrivateKeyParameters) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = (XMSSPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, (ASN1Encodable)new XMSSKeyParams(xMSSPrivateKeyParameters.getParameters().getHeight(), Utils.xmssLookupTreeAlgID((String)xMSSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)PrivateKeyInfoFactory.xmssCreateKeyStructure((XMSSPrivateKeyParameters)xMSSPrivateKeyParameters), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof XMSSMTPrivateKeyParameters) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = (XMSSMTPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, (ASN1Encodable)new XMSSMTKeyParams(xMSSMTPrivateKeyParameters.getParameters().getHeight(), xMSSMTPrivateKeyParameters.getParameters().getLayers(), Utils.xmssLookupTreeAlgID((String)xMSSMTPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)PrivateKeyInfoFactory.xmssmtCreateKeyStructure((XMSSMTPrivateKeyParameters)xMSSMTPrivateKeyParameters), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof McElieceCCA2PrivateKeyParameters) {
            McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters = (McElieceCCA2PrivateKeyParameters)asymmetricKeyParameter;
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = new McElieceCCA2PrivateKey(mcElieceCCA2PrivateKeyParameters.getN(), mcElieceCCA2PrivateKeyParameters.getK(), mcElieceCCA2PrivateKeyParameters.getField(), mcElieceCCA2PrivateKeyParameters.getGoppaPoly(), mcElieceCCA2PrivateKeyParameters.getP(), Utils.getAlgorithmIdentifier((String)mcElieceCCA2PrivateKeyParameters.getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)mcElieceCCA2PrivateKey);
        }
        if (asymmetricKeyParameter instanceof FrodoPrivateKeyParameters) {
            FrodoPrivateKeyParameters frodoPrivateKeyParameters = (FrodoPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = frodoPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.frodoOidLookup((FrodoParameters)frodoPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof SABERPrivateKeyParameters) {
            SABERPrivateKeyParameters sABERPrivateKeyParameters = (SABERPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = sABERPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.saberOidLookup((SABERParameters)sABERPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof NTRUPrivateKeyParameters) {
            NTRUPrivateKeyParameters nTRUPrivateKeyParameters = (NTRUPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = nTRUPrivateKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.ntruOidLookup((NTRUParameters)nTRUPrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof FalconPrivateKeyParameters) {
            FalconPrivateKeyParameters falconPrivateKeyParameters = (FalconPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.falconOidLookup((FalconParameters)falconPrivateKeyParameters.getParameters()));
            FalconPublicKey falconPublicKey = new FalconPublicKey(falconPrivateKeyParameters.getPublicKey());
            FalconPrivateKey falconPrivateKey = new FalconPrivateKey(0, falconPrivateKeyParameters.getSpolyf(), falconPrivateKeyParameters.getG(), falconPrivateKeyParameters.getSpolyF(), falconPublicKey);
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)falconPrivateKey, aSN1Set);
        }
        if (asymmetricKeyParameter instanceof MLKEMPrivateKeyParameters) {
            MLKEMPrivateKeyParameters mLKEMPrivateKeyParameters = (MLKEMPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.mlkemOidLookup((MLKEMParameters)mLKEMPrivateKeyParameters.getParameters()));
            byte[] byArray = mLKEMPrivateKeyParameters.getSeed();
            if (byArray == null) {
                return new PrivateKeyInfo(algorithmIdentifier, mLKEMPrivateKeyParameters.getEncoded(), aSN1Set);
            }
            return new PrivateKeyInfo(algorithmIdentifier, byArray, aSN1Set);
        }
        if (asymmetricKeyParameter instanceof NTRULPRimePrivateKeyParameters) {
            NTRULPRimePrivateKeyParameters nTRULPRimePrivateKeyParameters = (NTRULPRimePrivateKeyParameters)asymmetricKeyParameter;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getEnca()));
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getPk()));
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getRho()));
            aSN1EncodableVector.add(new DEROctetString(nTRULPRimePrivateKeyParameters.getHash()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.ntrulprimeOidLookup((NTRULPRimeParameters)nTRULPRimePrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DERSequence(aSN1EncodableVector), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof SNTRUPrimePrivateKeyParameters) {
            SNTRUPrimePrivateKeyParameters sNTRUPrimePrivateKeyParameters = (SNTRUPrimePrivateKeyParameters)asymmetricKeyParameter;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getF()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getGinv()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getPk()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getRho()));
            aSN1EncodableVector.add(new DEROctetString(sNTRUPrimePrivateKeyParameters.getHash()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.sntruprimeOidLookup((SNTRUPrimeParameters)sNTRUPrimePrivateKeyParameters.getParameters()));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DERSequence(aSN1EncodableVector), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof MLDSAPrivateKeyParameters) {
            MLDSAPrivateKeyParameters mLDSAPrivateKeyParameters = (MLDSAPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.mldsaOidLookup((MLDSAParameters)mLDSAPrivateKeyParameters.getParameters()));
            byte[] byArray = mLDSAPrivateKeyParameters.getSeed();
            if (byArray == null) {
                MLDSAPublicKeyParameters mLDSAPublicKeyParameters = mLDSAPrivateKeyParameters.getPublicKeyParameters();
                return new PrivateKeyInfo(algorithmIdentifier, mLDSAPrivateKeyParameters.getEncoded(), aSN1Set, mLDSAPublicKeyParameters.getEncoded());
            }
            MLDSAPublicKeyParameters mLDSAPublicKeyParameters = mLDSAPrivateKeyParameters.getPublicKeyParameters();
            return new PrivateKeyInfo(algorithmIdentifier, mLDSAPrivateKeyParameters.getSeed(), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof DilithiumPrivateKeyParameters) {
            DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters = (DilithiumPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.dilithiumOidLookup((DilithiumParameters)dilithiumPrivateKeyParameters.getParameters()));
            DilithiumPublicKeyParameters dilithiumPublicKeyParameters = dilithiumPrivateKeyParameters.getPublicKeyParameters();
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(dilithiumPrivateKeyParameters.getEncoded()), aSN1Set, dilithiumPublicKeyParameters.getEncoded());
        }
        if (asymmetricKeyParameter instanceof BIKEPrivateKeyParameters) {
            BIKEPrivateKeyParameters bIKEPrivateKeyParameters = (BIKEPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.bikeOidLookup((BIKEParameters)bIKEPrivateKeyParameters.getParameters()));
            byte[] byArray = bIKEPrivateKeyParameters.getEncoded();
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof HQCPrivateKeyParameters) {
            HQCPrivateKeyParameters hQCPrivateKeyParameters = (HQCPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.hqcOidLookup((HQCParameters)hQCPrivateKeyParameters.getParameters()));
            byte[] byArray = hQCPrivateKeyParameters.getEncoded();
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof RainbowPrivateKeyParameters) {
            RainbowPrivateKeyParameters rainbowPrivateKeyParameters = (RainbowPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(Utils.rainbowOidLookup((RainbowParameters)rainbowPrivateKeyParameters.getParameters()));
            byte[] byArray = rainbowPrivateKeyParameters.getEncoded();
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set);
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey xmssCreateKeyStructure(XMSSPrivateKeyParameters xMSSPrivateKeyParameters) throws IOException {
        byte[] byArray = xMSSPrivateKeyParameters.getEncoded();
        int n = xMSSPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n2 = xMSSPrivateKeyParameters.getParameters().getHeight();
        int n3 = 4;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        int n9 = (int)XMSSUtil.bytesToXBigEndian((byte[])byArray, (int)n8, (int)n3);
        if (!XMSSUtil.isIndexValid((int)n2, (long)n9)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n3), (int)n4);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n4), (int)n5);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n5), (int)n6);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n6), (int)n7);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n7), (int)(byArray.length - n8));
        BDS bDS = null;
        try {
            bDS = (BDS)XMSSUtil.deserialize((byte[])byArray6, BDS.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDS: " + classNotFoundException.getMessage());
        }
        if (bDS.getMaxIndex() != (1 << n2) - 1) {
            return new XMSSPrivateKey(n9, byArray2, byArray3, byArray4, byArray5, byArray6, bDS.getMaxIndex());
        }
        return new XMSSPrivateKey(n9, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    private static XMSSMTPrivateKey xmssmtCreateKeyStructure(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) throws IOException {
        byte[] byArray = xMSSMTPrivateKeyParameters.getEncoded();
        int n = xMSSMTPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n2 = xMSSMTPrivateKeyParameters.getParameters().getHeight();
        int n3 = (n2 + 7) / 8;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        int n9 = (int)XMSSUtil.bytesToXBigEndian((byte[])byArray, (int)n8, (int)n3);
        if (!XMSSUtil.isIndexValid((int)n2, (long)n9)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n3), (int)n4);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n4), (int)n5);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n5), (int)n6);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n6), (int)n7);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n7), (int)(byArray.length - n8));
        BDSStateMap bDSStateMap = null;
        try {
            bDSStateMap = (BDSStateMap)XMSSUtil.deserialize((byte[])byArray6, BDSStateMap.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDSStateMap: " + classNotFoundException.getMessage());
        }
        if (bDSStateMap.getMaxIndex() != (1L << n2) - 1L) {
            return new XMSSMTPrivateKey((long)n9, byArray2, byArray3, byArray4, byArray5, byArray6, bDSStateMap.getMaxIndex());
        }
        return new XMSSMTPrivateKey((long)n9, byArray2, byArray3, byArray4, byArray5, byArray6);
    }
}

