/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.processor;

import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessorResult;
import java.util.List;

public class EventProcessorResultImpl
implements EventProcessorResult {
    private int totalCount;
    private int resultCount;
    List<EventLimiterResult> limiterResults;

    public EventProcessorResultImpl(int totalCount, List<EventLimiterResult> results) {
        this.limiterResults = results;
        this.totalCount = totalCount;
        this.resultCount = 0;
    }

    @Override
    public boolean isLimited() {
        if (this.limiterResults == null) {
            return false;
        }
        for (EventLimiterResult limiter : this.limiterResults) {
            if (limiter.isLimited()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAggregated() {
        if (this.limiterResults != null && this.limiterResults.size() > 0) {
            return this.limiterResults.get(0).isAggregated();
        }
        return false;
    }

    @Override
    public List<EventLimiterResult> getLimiterResults() {
        return this.limiterResults;
    }

    @Override
    public int getInputEventCount() {
        return this.totalCount;
    }

    @Override
    public int getOutputEventCount() {
        this.resultCount = 0;
        for (EventLimiterResult limiter : this.limiterResults) {
            this.resultCount += limiter.getEventAggregates() != null ? limiter.getEventAggregates().length : limiter.getEventsNotAggregated().length;
        }
        return this.resultCount;
    }
}

