/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.util;

import com.mulesoft.dias.util.ConsoleLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileProcessingUtils {
    public static boolean processContent(String originalContent, StringBuilder updatedContent) {
        String[] lines = originalContent.split(System.lineSeparator());
        boolean hasPathChanges = false;
        String[] stringArray = lines;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String line;
            String updatedLine = line = stringArray[i];
            if (line.contains("pattern:") || line.contains("regex:")) {
                updatedContent.append(updatedLine).append(System.lineSeparator());
                continue;
            }
            if (!line.contains("\\")) {
                updatedContent.append(updatedLine).append(System.lineSeparator());
                continue;
            }
            ConsoleLogger.debug("Processing line with backslashes: " + line);
            Matcher quotedMatcher = Pattern.compile("\"([^\"]*\\\\[^\"]*)\"").matcher(updatedLine);
            StringBuffer sb = new StringBuffer();
            boolean foundMatch = false;
            while (quotedMatcher.find()) {
                foundMatch = true;
                String path = quotedMatcher.group(1);
                String unixPath = path.replace("\\", "/");
                ConsoleLogger.debug("  Converting double-quoted path: '" + path + "' to '" + unixPath + "'");
                quotedMatcher.appendReplacement(sb, "\"" + unixPath.replace("$", "\\$") + "\"");
                hasPathChanges = true;
            }
            if (foundMatch) {
                quotedMatcher.appendTail(sb);
                updatedLine = sb.toString();
            }
            Matcher singleQuotedMatcher = Pattern.compile("'([^']*\\\\[^']*)'").matcher(updatedLine);
            sb = new StringBuffer();
            foundMatch = false;
            while (singleQuotedMatcher.find()) {
                foundMatch = true;
                String path = singleQuotedMatcher.group(1);
                String unixPath = path.replace("\\", "/");
                ConsoleLogger.debug("  Converting single-quoted path: '" + path + "' to '" + unixPath + "'");
                singleQuotedMatcher.appendReplacement(sb, "'" + unixPath.replace("$", "\\$") + "'");
                hasPathChanges = true;
            }
            if (foundMatch) {
                singleQuotedMatcher.appendTail(sb);
                updatedLine = sb.toString();
            }
            Matcher unquotedMatcher = Pattern.compile("(:\\s*|\\-\\s+)([^\"'\\s][^\\s]*\\\\[^\\s]*)").matcher(updatedLine);
            sb = new StringBuffer();
            foundMatch = false;
            while (unquotedMatcher.find()) {
                foundMatch = true;
                String prefix = unquotedMatcher.group(1);
                String path = unquotedMatcher.group(2);
                String unixPath = path.replace("\\", "/");
                ConsoleLogger.debug("  Converting unquoted path: '" + path + "' to '" + unixPath + "'");
                unquotedMatcher.appendReplacement(sb, prefix + unixPath.replace("$", "\\$"));
                hasPathChanges = true;
            }
            if (foundMatch) {
                unquotedMatcher.appendTail(sb);
                updatedLine = sb.toString();
            }
            if (updatedLine.contains("\\") && !updatedLine.contains("pattern:") && !updatedLine.contains("regex:")) {
                ConsoleLogger.warn("  WARNING: Line still contains backslashes after processing: " + updatedLine);
            }
            updatedContent.append(updatedLine).append(System.lineSeparator());
        }
        return hasPathChanges;
    }

    public static void main(String[] args) {
        Path dirPath;
        if (args.length < 1) {
            ConsoleLogger.error("Please provide a directory path as the first argument.");
            System.exit(1);
        }
        if (!Files.exists(dirPath = Paths.get(args[0], new String[0]), new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
            ConsoleLogger.error("Provided path is not a valid directory: " + dirPath);
            System.exit(1);
        }
        try (Stream<Path> files = Files.walk(dirPath, new FileVisitOption[0]);){
            List yamlFiles = files.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".yml")).collect(Collectors.toList());
            for (Path yamlFilePath : yamlFiles) {
                try {
                    byte[] bytes = Files.readAllBytes(yamlFilePath);
                    String originalContent = new String(bytes, StandardCharsets.UTF_8);
                    boolean containsWindowsPaths = originalContent.contains("\\");
                    if (!containsWindowsPaths) {
                        ConsoleLogger.info("No Windows paths (backslashes) found in: " + yamlFilePath);
                        continue;
                    }
                    StringBuilder updatedContent = new StringBuilder();
                    boolean changed = FileProcessingUtils.processContent(originalContent, updatedContent);
                    if (changed) {
                        Files.write(yamlFilePath, updatedContent.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        ConsoleLogger.info("Updated file: " + yamlFilePath);
                        continue;
                    }
                    ConsoleLogger.info("No changes needed for: " + yamlFilePath);
                }
                catch (IOException e) {
                    ConsoleLogger.error("Failed to process file: " + yamlFilePath);
                    e.printStackTrace(System.err);
                }
            }
        }
        catch (IOException e) {
            ConsoleLogger.error("Error walking directory: " + dirPath);
            e.printStackTrace(System.err);
        }
    }
}

