/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.util.concurrent.Uninterruptibles;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.services.Switcher;
import com.mulesoft.analytics.collector.abp.CorePricingStatsProvider;
import com.mulesoft.analytics.collector.abp.MuleStatsProvider;
import com.mulesoft.analytics.collector.agent.CustomMetricHandler;
import com.mulesoft.analytics.collector.agent.YamlApplicationPropertiesService;
import com.mulesoft.analytics.collector.config.AgentConfigurator;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.CountryDbDownloader;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.config.OneTimeThreadExecutor;
import com.mulesoft.analytics.collector.config.SingleTimeoutTaskExecutor;
import com.mulesoft.analytics.collector.config.model.RuntimeConfig;
import com.mulesoft.analytics.collector.log.CustomMetricLogWriter;
import com.mulesoft.analytics.collector.log.MeteringLogWriter;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import com.mulesoft.analytics.collector.log.MetricV2LogWriter;
import com.mulesoft.analytics.collector.log.RawApiMetricLogWriter;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CollectorAgentBase
implements Switcher {
    protected static final Logger LOGGER = LogManager.getLogger(CollectorAgentBase.class);
    @Configurable(method="isEnabledByDefault")
    protected boolean enabled;
    @Configurable(type=Type.DYNAMIC, level=ConfigurationLevel.GLOBAL)
    @Nullable
    protected RuntimeConfig runtimeConfig;
    @Inject
    protected Configuration configuration;
    @Inject
    protected AgentConfigurator agentConfigurator;
    @Inject
    protected PipelineRegistry pipelineRegistry;
    @Inject
    protected CustomMetricHandler customMetricHandler;
    @Inject
    protected MetricLogWriter logWriter;
    @Inject
    protected MetricV2LogWriter v2LogWriter;
    @Inject
    protected MeteringLogWriter meteringLogWriter;
    @Inject
    protected RawApiMetricLogWriter rawApiLogWriter;
    @Inject
    protected CountryDbDownloader countryDbDownloader;
    @Inject
    protected CustomMetricLogWriter customMetricLogWriter;
    @Inject
    protected YamlApplicationPropertiesService yamlApplicationPropertiesService;
    @Nullable
    volatile OneTimeThreadExecutor delayedInitializer;
    private CountDownLatch initCompletionLatch = new CountDownLatch(1);
    private SingleTimeoutTaskExecutor countryDbDownloadExecutor = new SingleTimeoutTaskExecutor("GeoDb-Scheduled-%d", 30L, TimeUnit.MINUTES);

    protected abstract void onCollectorStart();

    protected void onCollectorPreStart() {
    }

    protected abstract void onCollectorStop();

    @Nullable
    protected abstract Properties getAgentAppProps(String var1);

    public boolean isEnabledByDefault() {
        return true;
    }

    public void enable(boolean state) {
        LOGGER.debug("Enable: {}", (Object)state);
        if (state) {
            if (this.configuration.isAgentStarted()) {
                this.startCollector(this.configuration.getMuleMajorVersion());
            }
        } else {
            this.stopCollector();
        }
        this.enabled = state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void internalInit() {
        try {
            if (this.configuration.isRunning()) {
                return;
            }
            this.onCollectorPreStart();
            if (!this.configuration.isEnabled()) {
                LOGGER.info("Not configured or disabled");
                return;
            }
            LOGGER.info("Starting");
            this.configuration.logConfiguration();
            this.logWriter.init(this.configuration);
            this.meteringLogWriter.init(this.configuration);
            this.v2LogWriter.init(this.configuration);
            this.rawApiLogWriter.init(this.configuration);
            this.customMetricLogWriter.init(this.configuration);
            if (this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
                this.agentConfigurator.generateOTelCommonConfigFile();
                this.agentConfigurator.generateMetricLogConfigFile();
            }
            this.countryDbDownloadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CollectorAgentBase.this.countryDbDownloader.download();
                }
            });
            this.onCollectorStart();
        }
        finally {
            this.configuration.setRunning(true);
            this.delayedInitializer = null;
            this.initCompletionLatch.countDown();
        }
    }

    protected void startCollector(int muleMajorVersion) {
        LOGGER.debug("Start request");
        this.configuration.setMuleMajorVersion(muleMajorVersion);
        if (this.runtimeConfig != null) {
            this.configuration.setRuntimeConfig(this.runtimeConfig);
        }
        this.configuration.setAgentStarted(true);
        DeploymentType type = this.configuration.getDeploymentType();
        if (type == DeploymentType.RTF || type == DeploymentType.HYBRID || this.configuration.getOrgId() != null) {
            this.internalInit();
        } else {
            LOGGER.info("Delaying initialization until application deployment. DeploymentType: " + (Object)((Object)type));
            this.delayedInitializer = new OneTimeThreadExecutor(new Runnable(){

                @Override
                public void run() {
                    CollectorAgentBase.this.internalInit();
                }
            });
        }
    }

    protected void completeDelayedInitialization() {
        if (this.delayedInitializer != null) {
            this.delayedInitializer.trigger();
        }
        this.awaitInitializationComplete(1L, TimeUnit.MINUTES);
    }

    protected void awaitInitializationComplete(long timeout, TimeUnit unit) {
        if (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.initCompletionLatch, (long)timeout, (TimeUnit)unit)) {
            LOGGER.warn("Initialization timed out");
        }
    }

    public void stopCollector() {
        LOGGER.debug("Stop request");
        if (this.configuration.isRunning() && this.configuration.isEnabled()) {
            LOGGER.info("Stopping");
            this.onCollectorStop();
            this.logWriter.close();
            this.meteringLogWriter.close();
            this.v2LogWriter.close();
            this.rawApiLogWriter.close();
        }
        this.configuration.setRunning(false);
    }

    protected void loadAppSpecificProperties(String appId, Map<String, String> muleProperties) {
        String overrideAppId = this.configuration.overrideAppId(appId);
        if (overrideAppId == null) {
            return;
        }
        Properties agentAppProps = this.getAgentAppProps(overrideAppId);
        if (agentAppProps != null) {
            this.configuration.addAppSpecificProperties(overrideAppId, agentAppProps);
        }
        Properties vizMuleProps = new Properties();
        for (Map.Entry<String, String> entry : muleProperties.entrySet()) {
            if (!entry.getKey().startsWith("anypoint.platform.visualizer.")) continue;
            vizMuleProps.setProperty(entry.getKey(), entry.getValue());
        }
        this.configuration.addAppSpecificProperties(overrideAppId, vizMuleProps);
        this.configuration.addAppSpecificProperties(overrideAppId, this.yamlApplicationPropertiesService.getPropertiesForApplication(overrideAppId));
    }

    protected void registerCorePricingMetricsCollectors(String appName, CorePricingStatsProvider corePricingStatsProvider) {
        String appId = this.configuration.overrideAppId(appName);
        if (appId == null) {
            LOGGER.error("Cannot resolve appId for app: {}", (Object)appName);
            return;
        }
        if (this.configuration.isCorePricingEnabled()) {
            if (this.pipelineRegistry.isCorePricingStatsMetricPipelinePresent(appId)) {
                LOGGER.info("Core pricing metrics are already enabled for app: {}", (Object)appId);
            } else if (corePricingStatsProvider.isEnabled()) {
                if (!this.meteringLogWriter.isInitialized()) {
                    this.meteringLogWriter.init(this.configuration);
                }
                this.pipelineRegistry.startCorePricingStatsMetricPipeline(appId, corePricingStatsProvider);
                LOGGER.info("Start collecting CorePricingStats metrics with frequency {} for app: {}", (Object)this.configuration.getMuleMetricCollectionInterval(), (Object)appId);
            }
        } else {
            LOGGER.error("Core Pricing Metrics is disabled.");
            if (this.pipelineRegistry.stopCorePricingStatsMetricPipeline(appId)) {
                LOGGER.info("Stop CorePricingStats metrics for app: {}", (Object)appId);
            }
        }
    }

    protected void registerAbpMetricsCollectors(String appName, MuleStatsProvider muleStatsProvider) {
        String appId = this.configuration.overrideAppId(appName);
        if (appId == null) {
            LOGGER.error("Cannot resolve appId for app: {}", (Object)appName);
            return;
        }
        if (this.configuration.isMuleStatsEnabled()) {
            if (this.pipelineRegistry.isMuleStatsMetricPipelinePresent(appId)) {
                LOGGER.info("MuleStats metrics are already enabled for app: {}", (Object)appId);
            } else {
                if (!muleStatsProvider.isEnabled()) {
                    LOGGER.error("Cannot enable collection of MuleStats metrics due to missing ApplicationStatistics");
                    return;
                }
                if (!this.meteringLogWriter.isInitialized()) {
                    this.meteringLogWriter.init(this.configuration);
                }
                this.pipelineRegistry.startMuleStatsMetricPipeline(appId, muleStatsProvider);
                if (!this.v2LogWriter.isInitialized()) {
                    this.v2LogWriter.init(this.configuration);
                }
                LOGGER.info("Start collecting MuleStats metrics with frequency {} for app: {}", (Object)this.configuration.getMuleMetricCollectionInterval(), (Object)appId);
            }
        } else if (this.pipelineRegistry.stopMuleStatsMetricPipeline(appId)) {
            LOGGER.info("Stop MuleStats metrics for app: {}", (Object)appId);
        }
    }
}

