/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.analytics.collector.agent.ApiMetadataExtractor;
import com.mulesoft.analytics.collector.agent.AppStatsHandler;
import com.mulesoft.analytics.collector.agent.CollectorAgentBase;
import com.mulesoft.analytics.collector.agent.ConnectorNotificationListener;
import com.mulesoft.analytics.collector.agent.CorePricingStatsProviderImpl;
import com.mulesoft.analytics.collector.agent.CustomNotificationListener;
import com.mulesoft.analytics.collector.agent.HttpExtensionNotificationListener;
import com.mulesoft.analytics.collector.agent.MuleContextHandler;
import com.mulesoft.analytics.collector.agent.MuleStatsProviderImpl;
import com.mulesoft.analytics.collector.agent.PayloadStatsCollector;
import com.mulesoft.analytics.collector.agent.ProcessorNotificationListener;
import com.mulesoft.analytics.collector.agent.RamlBasedEndpointTemplateSupplier;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.policy.PolicyUtils;
import com.mulesoft.analytics.collector.util.MuleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationPolicyManager;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.analytics.collector")
@Singleton
public class CollectorAgentService
extends CollectorAgentBase
implements MuleAgentService,
DeploymentServiceAware,
Startable,
Stoppable {
    protected static final String HEADERS_REGISTRY = "http.request.fixedHeadersRegistry";
    protected static final String HEADERS_PER_APP_REGISTRY = "http.request.fixedHeadersPerAppRegistry";
    @Inject
    private List<InternalMessageHandler<?>> messageHandlerList = Collections.emptyList();
    @Inject
    private AgentApplicationPropertiesService agentApplicationPropertiesService;
    @Inject
    protected ApiMetadataExtractor apiMetadataExtractor;
    @Nullable
    private AppStatsHandler appStatsHandler;
    @Nullable
    private MuleContextHandler muleContextHandler;
    @Nullable
    private DeploymentService deploymentService;
    @Nullable
    private DeploymentListener deploymentListener;
    @Nullable
    private Thread shutdownListener;
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ConnectorNotificationListener> connectorListeners = new HashMap<String, ConnectorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ProcessorNotificationListener> processorListeners = new HashMap<String, ProcessorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, HttpExtensionNotificationListener> extensionListeners = new HashMap<String, HttpExtensionNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, CustomNotificationListener> customListeners = new HashMap<String, CustomNotificationListener>();
    private final Object notificationListenersLock = new Object();

    public void start() {
        this.startCollector(4);
    }

    @Override
    protected void onCollectorStart() {
        this.registerListenersForAllApps();
        for (InternalMessageHandler<?> handler : this.messageHandlerList) {
            if (handler instanceof AppStatsHandler) {
                this.appStatsHandler = (AppStatsHandler)handler;
                break;
            }
            if (!(handler instanceof MuleContextHandler)) continue;
            this.muleContextHandler = (MuleContextHandler)handler;
        }
    }

    @Override
    protected void onCollectorPreStart() {
        this.registerAbpMetricsCollectorsForAllApps();
    }

    public void stop() {
        this.stopCollector();
    }

    @Override
    protected void onCollectorStop() {
        this.unregisterListenersForAllApps();
    }

    @Override
    @Nullable
    protected Properties getAgentAppProps(String overrideAppId) {
        if (this.agentApplicationPropertiesService != null) {
            return this.agentApplicationPropertiesService.getPropertiesForApplication(overrideAppId);
        }
        return null;
    }

    public void setDeploymentService(@Nullable DeploymentService deploymentService) {
        if (this.deploymentService != deploymentService) {
            this.deploymentService = deploymentService;
            if (this.deploymentListener == null) {
                this.deploymentListener = new CollectorDeploymentListener();
            }
            if (this.deploymentService != null) {
                this.deploymentService.addDeploymentListener(this.deploymentListener);
            }
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.messageHandlerList);
    }

    private void registerListeners(String appId, Registry registry) {
        MuleUtils.registryLookupByType(appId, registry, NotificationListenerRegistry.class).ifPresent(notificationsRegistry -> {
            try {
                String overrideAppId = this.configuration.overrideAppId(appId);
                LOGGER.info("Registering listeners for application {}", (Object)overrideAppId);
                if (overrideAppId == null) {
                    return;
                }
                Object object = this.notificationListenersLock;
                synchronized (object) {
                    if (!this.connectorListeners.containsKey(overrideAppId)) {
                        ConnectorNotificationListener connectorListener = new ConnectorNotificationListener(this.pipelineRegistry, overrideAppId, appId, registry, new RamlBasedEndpointTemplateSupplier(overrideAppId, registry));
                        notificationsRegistry.registerListener((NotificationListener)connectorListener);
                        this.connectorListeners.put(overrideAppId, connectorListener);
                    }
                    if (!this.processorListeners.containsKey(overrideAppId)) {
                        ProcessorNotificationListener processorListener = new ProcessorNotificationListener(this.pipelineRegistry, this.logWriter, overrideAppId);
                        notificationsRegistry.registerListener((NotificationListener)processorListener);
                        this.processorListeners.put(overrideAppId, processorListener);
                    }
                    if (!this.extensionListeners.containsKey(overrideAppId)) {
                        HttpExtensionNotificationListener extensionListener = new HttpExtensionNotificationListener(this.pipelineRegistry, this.logWriter, overrideAppId);
                        notificationsRegistry.registerListener((NotificationListener)extensionListener);
                        this.extensionListeners.put(overrideAppId, extensionListener);
                    }
                    if (!this.customListeners.containsKey(overrideAppId)) {
                        CustomNotificationListener customListener = new CustomNotificationListener(this.customMetricHandler, overrideAppId);
                        notificationsRegistry.registerListener((NotificationListener)customListener);
                        this.customListeners.put(overrideAppId, customListener);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not register listeners for application " + appId, (Throwable)e);
            }
        });
    }

    void registerListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                String appName = app.getArtifactName();
                this.configuration.setAppDeployed(appName);
                Registry registry = app.getRegistry();
                if (registry != null) {
                    this.registerListeners(appName, registry);
                    this.registerHeaderInjection(appName, app, registry);
                    this.loadAppSpecificProperties(appName, MuleUtils.lookupStringProperties(appName, registry));
                    this.provideAppStatsExtraFields(appName, registry);
                }
                MuleUtils.getAppRegionClassLoader(app).ifPresent(classLoader -> this.agentConfigurator.generateAppLogConfigFile(appName, (ClassLoader)classLoader));
            }
        }
    }

    private void unregisterListeners(String appId, Registry registry) {
        MuleUtils.registryLookupByType(appId, registry, NotificationListenerRegistry.class).ifPresent(notificationsRegistry -> {
            String overrideAppId = this.configuration.overrideAppId(appId);
            if (overrideAppId != null) {
                LOGGER.info("Un-registering listeners for application {}", (Object)overrideAppId);
                Object object = this.notificationListenersLock;
                synchronized (object) {
                    CustomNotificationListener customListener;
                    HttpExtensionNotificationListener extensionListener;
                    ConnectorNotificationListener connectorListener;
                    ProcessorNotificationListener processorListener = this.processorListeners.remove(overrideAppId);
                    if (processorListener != null) {
                        notificationsRegistry.unregisterListener((NotificationListener)processorListener);
                    }
                    if ((connectorListener = this.connectorListeners.remove(overrideAppId)) != null) {
                        notificationsRegistry.unregisterListener((NotificationListener)connectorListener);
                    }
                    if ((extensionListener = this.extensionListeners.remove(overrideAppId)) != null) {
                        notificationsRegistry.unregisterListener((NotificationListener)extensionListener);
                    }
                    if ((customListener = this.customListeners.remove(overrideAppId)) != null) {
                        notificationsRegistry.unregisterListener((NotificationListener)customListener);
                    }
                }
            }
        });
    }

    void unregisterListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                String appName = app.getArtifactName();
                Registry registry = app.getRegistry();
                if (registry != null) {
                    this.unregisterListeners(appName, registry);
                }
                if (this.appStatsHandler != null) {
                    this.appStatsHandler.unregisterApp(appName);
                }
                this.configuration.removeAppSpecificProperties(appName);
            }
        }
    }

    void registerHeaderInjection(String appName, Application app, Registry registry) {
        if (!this.configuration.isHeaderInjectionEnabled()) {
            LOGGER.info("Header injection explicitly disabled for app: {}", (Object)appName);
            return;
        }
        if ((appName = this.configuration.overrideAppId(appName)) == null) {
            return;
        }
        String workerHash = this.configuration.generateWorkerHash(appName);
        if (workerHash == null) {
            return;
        }
        try {
            Optional headersPerApp = registry.lookupByName(HEADERS_PER_APP_REGISTRY);
            if (headersPerApp.isPresent()) {
                Map perAppMap = (Map)headersPerApp.get();
                Map appHeaders = perAppMap.computeIfAbsent(appName, k -> new HashMap());
                appHeaders.put("x-anypnt-app-worker", Collections.singletonList(workerHash));
                LOGGER.info("Fast header injection (per-app registry) enabled for app: {}", (Object)appName);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception", (Throwable)e);
        }
        try {
            Optional headers = registry.lookupByName(HEADERS_REGISTRY);
            if (headers.isPresent()) {
                ((HashMap)headers.get()).put("x-anypnt-app-worker", Collections.singletonList(workerHash));
                LOGGER.info("Fast header injection enabled for app: {}", (Object)appName);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception", (Throwable)e);
        }
        if (this.configuration.getDeploymentType() != DeploymentType.CLOUDHUB && this.configuration.isHeaderInjectionPropertySet() && this.configuration.isHeaderInjectionEnabled()) {
            try {
                ApplicationPolicyManager policyManager = app.getPolicyManager();
                PolicyUtils.registerHeaderInjectionPolicy(policyManager, workerHash);
                LOGGER.info("Policy-based header injection enabled for app: {}", (Object)appName);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to register http-header-injection policy for app: " + appName + ". This may affect Anypoint Visualization functionality", (Throwable)e);
            }
        } else {
            LOGGER.info("Header injection implicitly disabled for app: {}", (Object)appName);
        }
    }

    private void provideAppStatsExtraFields(String appName, Registry registry) {
        if (this.appStatsHandler != null) {
            this.appStatsHandler.addApiIds(this.configuration.overrideAppId(appName), this.apiMetadataExtractor.getApiIds(registry));
            this.appStatsHandler.setMuleVersion(MuleManifest.getProductVersion());
        }
    }

    private void registerAbpMetricsCollectors(String appName, Registry registry) {
        Optional mc = MuleUtils.registryLookupByName(appName, registry, "_muleContext");
        if (mc.isPresent()) {
            MuleStatsProviderImpl muleStatsProvider = new MuleStatsProviderImpl((MuleContext)mc.get());
            this.registerAbpMetricsCollectors(appName, muleStatsProvider);
            CorePricingStatsProviderImpl corePricingStatsProvider = new CorePricingStatsProviderImpl((MuleContext)mc.get(), this.configuration);
            this.registerCorePricingMetricsCollectors(appName, corePricingStatsProvider);
        } else {
            LOGGER.error("Cannot enable collection of ABP metrics due to missing MuleContext");
        }
        String appId = this.configuration.overrideAppId(appName);
        if (mc.isPresent() && appId != null) {
            String sessionId = this.configuration.getAbpSessionId();
            if (this.configuration.isPayloadMetricEnabled()) {
                if (this.pipelineRegistry.isPayloadStatsMetricPipelinePresent(appId)) {
                    LOGGER.info("PayloadStats metrics are already enabled for app: {}", (Object)appId);
                } else {
                    PayloadStatsCollector payloadStatsCollector = new PayloadStatsCollector((MuleContext)mc.get(), appId, sessionId, this.configuration.getPayloadMetricWhitelist(), this.configuration.getPayloadMetricBlacklist());
                    if (payloadStatsCollector.enablePayloadStats()) {
                        this.pipelineRegistry.startPayloadStatsMetricPipeline(appId, payloadStatsCollector);
                        if (!this.v2LogWriter.isInitialized()) {
                            this.v2LogWriter.init(this.configuration);
                        }
                        LOGGER.info("Start collecting PayloadStats metrics with frequency {} for app: {}", (Object)this.configuration.getPayloadMetricCollectionInterval(), (Object)appId);
                    }
                }
            } else {
                PayloadStatsCollector payloadStatsCollector = new PayloadStatsCollector((MuleContext)mc.get(), appId, sessionId, this.configuration.getPayloadMetricWhitelist(), this.configuration.getPayloadMetricBlacklist());
                if (this.pipelineRegistry.stopPayloadStatsMetricPipeline(appId)) {
                    LOGGER.info("Stop PayloadStats metrics for app: {}", (Object)appId);
                }
                if (payloadStatsCollector.disablePayloadStats()) {
                    LOGGER.info("Disable PayloadStats metrics for app: {}", (Object)appId);
                }
            }
        } else {
            LOGGER.info("Cannot enable collection of PayloadStats metrics due to missing MuleContext");
        }
    }

    void registerAbpMetricsCollectorsForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                String appName = app.getArtifactName();
                Registry registry = app.getRegistry();
                if (registry == null) continue;
                this.registerAbpMetricsCollectors(appName, registry);
            }
        }
    }

    private class CollectorDeploymentListener
    implements DeploymentListener {
        private CollectorDeploymentListener() {
        }

        public void onDeploymentSuccess(String appName) {
            CollectorAgentService.this.completeDelayedInitialization();
            if (CollectorAgentService.this.deploymentService != null) {
                Application app = CollectorAgentService.this.deploymentService.findApplication(appName);
                if (app != null) {
                    Registry registry = app.getRegistry();
                    if (registry != null) {
                        CollectorAgentService.this.registerAbpMetricsCollectors(appName, registry);
                        if (CollectorAgentService.this.configuration.isEnabled()) {
                            CollectorAgentService.this.configuration.setAppDeployed(appName);
                            CollectorAgentService.this.unregisterListeners(appName, registry);
                            CollectorAgentService.this.registerListeners(appName, registry);
                            CollectorAgentService.this.registerHeaderInjection(appName, app, registry);
                            CollectorAgentService.this.loadAppSpecificProperties(appName, MuleUtils.lookupStringProperties(appName, registry));
                            CollectorAgentService.this.provideAppStatsExtraFields(appName, registry);
                        }
                    } else {
                        CollectorAgentBase.LOGGER.error("Missing Registry for application: " + appName);
                    }
                    MuleUtils.getAppRegionClassLoader(app).ifPresent(classLoader -> CollectorAgentService.this.agentConfigurator.generateAppLogConfigFile(appName, (ClassLoader)classLoader));
                } else {
                    CollectorAgentBase.LOGGER.error("Application not found: " + appName);
                }
            }
        }

        public void onUndeploymentStart(String appName) {
            CollectorAgentService.this.pipelineRegistry.unregister(appName);
            if (CollectorAgentService.this.appStatsHandler != null) {
                CollectorAgentService.this.appStatsHandler.unregisterApp(appName);
            }
            CollectorAgentService.this.customMetricHandler.unregister(appName);
            CollectorAgentService.this.agentConfigurator.deleteAppLogConfigFile(appName);
            CollectorAgentService.this.configuration.removeAppSpecificProperties(appName);
            CollectorAgentService.this.configuration.setAppUndeployed(appName);
        }
    }
}

