/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec;

import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECFieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecT409Field;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.raw.Nat;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.raw.Nat448;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT409FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT409FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.bitLength() > 409) {
            throw new IllegalArgumentException("x value invalid for SecT409FieldElement");
        }
        this.x = SecT409Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecT409FieldElement() {
        this.x = Nat448.create64();
    }

    protected SecT409FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat448.isOne64((long[])this.x);
    }

    @Override
    public boolean isZero() {
        return Nat448.isZero64((long[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat448.toBigInteger64((long[])this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT409Field";
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        long[] lArray = Nat448.create64();
        SecT409Field.add((long[])this.x, (long[])((SecT409FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat448.create64();
        SecT409Field.addOne((long[])this.x, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        long[] lArray = Nat448.create64();
        SecT409Field.multiply((long[])this.x, (long[])((SecT409FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT409FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT409FieldElement)eCFieldElement2).x;
        long[] lArray4 = ((SecT409FieldElement)eCFieldElement3).x;
        long[] lArray5 = Nat.create64(13);
        SecT409Field.multiplyAddToExt((long[])lArray, (long[])lArray2, (long[])lArray5);
        SecT409Field.multiplyAddToExt((long[])lArray3, (long[])lArray4, (long[])lArray5);
        long[] lArray6 = Nat448.create64();
        SecT409Field.reduce((long[])lArray5, (long[])lArray6);
        return new SecT409FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat448.create64();
        SecT409Field.square((long[])this.x, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT409FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT409FieldElement)eCFieldElement2).x;
        long[] lArray4 = Nat.create64(13);
        SecT409Field.squareAddToExt((long[])lArray, (long[])lArray4);
        SecT409Field.multiplyAddToExt((long[])lArray2, (long[])lArray3, (long[])lArray4);
        long[] lArray5 = Nat448.create64();
        SecT409Field.reduce((long[])lArray4, (long[])lArray5);
        return new SecT409FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return this;
        }
        long[] lArray = Nat448.create64();
        SecT409Field.squareN((long[])this.x, (int)n, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement halfTrace() {
        long[] lArray = Nat448.create64();
        SecT409Field.halfTrace((long[])this.x, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT409Field.trace((long[])this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat448.create64();
        SecT409Field.invert((long[])this.x, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat448.create64();
        SecT409Field.sqrt((long[])this.x, (long[])lArray);
        return new SecT409FieldElement(lArray);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 409;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecT409FieldElement)) {
            return false;
        }
        SecT409FieldElement secT409FieldElement = (SecT409FieldElement)object;
        return Nat448.eq64((long[])this.x, (long[])secT409FieldElement.x);
    }

    public int hashCode() {
        return 0x3E68E7 ^ Arrays.hashCode(this.x, 0, 7);
    }
}

