/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.dias.mule.agent.DefaultCertificateDetails;
import com.mulesoft.dias.mule.agent.MuleAgentConfig;
import com.mulesoft.dias.service.AuthenticationProxyClient;
import com.mulesoft.dias.util.ConsoleLogger;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.net.URI;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;

public final class DefaultAuthenticationProxyClient
implements AuthenticationProxyClient {
    private final URI baseUrl;
    private final AsyncHttpClient client;
    private final ObjectMapper objectMapper;
    private final DefaultCertificateDetails certificateDetails;
    private final MuleAgentConfig muleAgentConfig;
    private static final String AUTHENTICATION_HTTP_HEADER_NAME = "Authorization";
    private static final String BEAR_TOKEN_PREFIX = "Bearer ";

    DefaultAuthenticationProxyClient(URI baseUrl, AsyncHttpClient client, ObjectMapper objectMapper, MuleAgentConfig muleAgentConfig) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.objectMapper = objectMapper;
        this.certificateDetails = new DefaultCertificateDetails("JKS");
        this.muleAgentConfig = muleAgentConfig;
    }

    @Override
    public <T> Response post(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            String url = this.baseUrl.resolve(path).toString();
            Request request = ((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePost(url).setHeaders(headers)).setHeader((CharSequence)"Content-Type", "application/json")).build();
            StringBuilder curlCommand = new StringBuilder("curl -X POST \"" + url + "\"");
            for (Map.Entry<CharSequence, Collection<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    curlCommand.append(" -H \"").append(entry.getKey()).append(": ").append(value).append("\"");
                }
            }
            curlCommand.append(" -H \"Content-Type: application/json\"");
            ConsoleLogger.info("Executing cURL: " + curlCommand);
            return (Response)this.client.executeRequest(request).get();
        }
        catch (InterruptedException e) {
            ConsoleLogger.warn("There was an error retrieving the response from a post request to the authentication server.");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            ConsoleLogger.warn("There was an error executing a post request to the authentication server.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Response post(String path) {
        return this.post(path, new Object(), new HashMap<CharSequence, Collection<String>>(0));
    }

    @Override
    public <T> Response post(String path, ProxyServer proxyServer) {
        HashMap<CharSequence, Collection<String>> headers = new HashMap<CharSequence, Collection<String>>(0);
        if (this.muleAgentConfig.isTrafficInspectionEnabled()) {
            headers.putAll(this.generateAuthHeader(this.certificateDetails));
        }
        return this.post(path, proxyServer, (Map<CharSequence, Collection<String>>)headers);
    }

    public <T> Response post(String path, ProxyServer proxyServer, Map<CharSequence, Collection<String>> headers) {
        try {
            ConsoleLogger.info("Posting a request to the authentication server " + path + " through proxy " + proxyServer.getHost() + ":" + proxyServer.getPort());
            if (headers.isEmpty() || !headers.containsKey(AUTHENTICATION_HTTP_HEADER_NAME)) {
                ConsoleLogger.warn("Missing the authentication header Authorization");
            } else {
                String bearToken = headers.get(AUTHENTICATION_HTTP_HEADER_NAME).toString();
                if (bearToken.startsWith(BEAR_TOKEN_PREFIX) && bearToken.equals(BEAR_TOKEN_PREFIX)) {
                    ConsoleLogger.error("Empty authentication token.");
                }
            }
            return (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePost(this.baseUrl.resolve(path).toString()).setHeaders(headers)).setHeader((CharSequence)"Content-Type", "application/json")).setProxyServer(proxyServer)).execute().get();
        }
        catch (InterruptedException e) {
            ConsoleLogger.warn("There was an error retrieving the response from a post request to the authentication server.");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            ConsoleLogger.warn("There was an error executing a post request to the authentication server.");
            throw new RuntimeException(e);
        }
    }

    public Map<CharSequence, Collection<String>> generateAuthHeader(DefaultCertificateDetails certificates) {
        HashMap<CharSequence, Collection<String>> authHeader = new HashMap<CharSequence, Collection<String>>();
        Key privateKey = certificates.getPrivateKey();
        Certificate[] certificatesChain = certificates.getCertChain();
        String muleServerId = certificates.getServerId();
        String jwt = this.generateJWT(privateKey, certificatesChain, muleServerId);
        authHeader.put(AUTHENTICATION_HTTP_HEADER_NAME, Collections.singletonList(BEAR_TOKEN_PREFIX + jwt));
        return authHeader;
    }

    private String generateJWT(Key privateKey, Certificate[] certificateChain, String muleServerId) {
        ArrayList<String> x5cList = new ArrayList<String>();
        try {
            for (Certificate certificate : certificateChain) {
                X509Certificate X509cert = (X509Certificate)certificate;
                String encodedCert = Base64.getEncoder().encodeToString(X509cert.getEncoded());
                x5cList.add(encodedCert);
            }
        }
        catch (CertificateEncodingException e) {
            ConsoleLogger.error("Failed to B64 encoded the client certificate" + e);
        }
        return Jwts.builder().setSubject(muleServerId).setIssuer("mule-agent").setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 300000L)).setNotBefore(new Date(System.currentTimeMillis() - 180000L)).claim("x5c", x5cList).signWith(privateKey).compact();
    }

    @Override
    public <T> Response put(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            return (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePut(this.baseUrl.resolve(path).toString()).setBody(this.objectMapper.writeValueAsString(body))).setHeaders(headers)).setHeader((CharSequence)"Content-Type", "application/json")).execute().get();
        }
        catch (JsonProcessingException e) {
            ConsoleLogger.warn("There was an error serializing the request body.");
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            ConsoleLogger.warn("There was an error retrieving the response from a put request to the authentication server.");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            ConsoleLogger.warn("There was an error executing a put request to the authentication server.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Response put(String path, T body) {
        return this.put(path, body, new HashMap<CharSequence, Collection<String>>(0));
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            ConsoleLogger.warn("The connection could not be closed.");
            throw new RuntimeException(e);
        }
    }
}

