/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.analytics.collector.agent.AbstractMessageHandler;
import com.mulesoft.analytics.collector.agent.JMXMetricParser;
import com.mulesoft.analytics.collector.agent.JMXOperatingSystemMetricProvider;
import com.mulesoft.analytics.collector.agent.RuntimeNumCoresService;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.metrics.EnvironmentProvider;
import com.mulesoft.analytics.collector.metrics.JsonFactLogger;
import com.mulesoft.analytics.collector.metrics.Metrics;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.dias.jvm")
@Singleton
public class JMXMetricHandler
extends AbstractMessageHandler
implements InternalMessageHandler<ArrayList<Metric>> {
    private static final Logger LOGGER = LogManager.getLogger(JMXMetricHandler.class);
    private static final String OPERATING_SYSTEM_METRIC_NAME = "operatingsystem";
    static final String JVM_CPU_OPERATING_SYSTEM_METRIC_NAME = "jvm.cpu.operatingsystem";
    static final String POD_CPU_METRIC_FIELD = "pod_cpu";
    static final String CPU_METRIC_FIELD = "cpu";
    static final String POD_CPU_REQUEST_METRIC_FIELD = "pod_cpu_request";
    static final String POD_CPU_LIMIT_METRIC_FIELD = "pod_cpu_limit";
    static final String POD_CPU_LIMIT_ENV_VAR = "POD_CPU_LIMIT";
    static final String POD_CPU_REQUEST_ENV_VAR = "POD_CPU_REQUEST";
    private static final ImmutableMap<String, String> JVM_TO_OS_METRIC_CONVERSION_MAP = ImmutableMap.builder().put((Object)"available_processors", (Object)"available_processors").put((Object)"load_average", (Object)"system_load_average").put((Object)"cpu", (Object)"process_cpu_load").put((Object)"total_physical_memory_size", (Object)"total_physical_memory_size").build();
    @Inject
    private JMXMetricParser jmxParser;
    @Inject
    private JMXOperatingSystemMetricProvider metricProvider;
    @Inject
    private RuntimeNumCoresService runtimeNumCoresService;
    private final Supplier<JsonFactLogger> jsonFactLoggerSupplier = Suppliers.memoize((Supplier)new Supplier<JsonFactLogger>(){

        public JsonFactLogger get() {
            return new JsonFactLogger(Metrics.SYSTEM_METRIC, new EnvironmentProvider(JMXMetricHandler.this.configuration, JMXMetricHandler.this.configuration.overrideAppId(null)), (ScheduledExecutorService)JMXMetricHandler.this.configuration.getScheduledExecutorService().get(), JMXMetricHandler.this.configuration.getAggregationTimeInterval(), JMXMetricHandler.this.configuration.getDeploymentType() == DeploymentType.RTF ? JMXMetricHandler.this.output : JMXMetricHandler.this.v2LogWriter, Metrics.BATCHER_SETTINGS_MAP);
        }
    });
    Supplier<Double> podCpuRequestSupplier = Suppliers.memoize(this.podCpuRequestSupplier());
    Supplier<Double> podCpuMultiplierSupplier = Suppliers.memoize(this.podCpuMultiplierSupplier());
    Supplier<Double> podCpuLimitSupplier = Suppliers.memoize(this.podCpuLimitSupplier());

    public boolean handle(ArrayList<Metric> message) {
        if (!this.isEnabled() || message == null) {
            return false;
        }
        List<Tuple<String, String>> tags = this.createSystemMetricTags();
        for (Metric metric : message) {
            this.parseAndWrite(metric, tags);
        }
        for (MetricRecord record : this.metricProvider.getMetrics(tags)) {
            ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).consume(new Event<Fact>(Fact.convert(record, OPERATING_SYSTEM_METRIC_NAME)));
        }
        return true;
    }

    private void parseAndWrite(Metric metric, List<Tuple<String, String>> tags) {
        Number value = metric.getValue();
        String name = metric.getName();
        try {
            MetricRecord record = this.jmxParser.parse(name, value, tags);
            if (null != record) {
                List<MetricRecord> podCpuMetric = this.generatePodCpuMetric(record);
                for (MetricRecord podCpuMetricRecord : podCpuMetric) {
                    ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).consume(new Event<Fact>(Fact.convert(podCpuMetricRecord, podCpuMetricRecord.getName())));
                }
                List<MetricRecord> osRecords = this.generateOsMetric(record);
                for (MetricRecord osRecord : osRecords) {
                    ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).consume(new Event<Fact>(Fact.convert(osRecord, osRecord.getName())));
                }
                ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).consume(new Event<Fact>(Fact.convert(record, record.getName())));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Unable to parse metric string '%s'", name), (Throwable)e);
        }
    }

    private List<MetricRecord> generatePodCpuMetric(MetricRecord metricRecord) {
        if (Objects.equals(this.podCpuMultiplierSupplier.get(), -1.0)) {
            return Collections.emptyList();
        }
        List<Tuple<String, String>> tags = metricRecord.getTags();
        List<Tuple<String, String>> values = metricRecord.getValues();
        ArrayList<MetricRecord> result = new ArrayList<MetricRecord>();
        for (Tuple<String, String> pair : values) {
            if (!pair.first().equals(CPU_METRIC_FIELD)) continue;
            double correctedCpuUsage = Double.parseDouble(pair.second()) * (Double)Objects.requireNonNull(this.podCpuMultiplierSupplier.get());
            result.add(MetricRecord.create(JVM_CPU_OPERATING_SYSTEM_METRIC_NAME, tags, Collections.singletonList(Tuple.tuple(POD_CPU_METRIC_FIELD, String.valueOf(correctedCpuUsage)))));
            result.add(MetricRecord.create(JVM_CPU_OPERATING_SYSTEM_METRIC_NAME, tags, Collections.singletonList(Tuple.tuple(POD_CPU_REQUEST_METRIC_FIELD, String.valueOf(this.podCpuRequestSupplier.get())))));
            result.add(MetricRecord.create(JVM_CPU_OPERATING_SYSTEM_METRIC_NAME, tags, Collections.singletonList(Tuple.tuple(POD_CPU_LIMIT_METRIC_FIELD, String.valueOf(this.podCpuLimitSupplier.get())))));
        }
        return result;
    }

    boolean arePodEnvVarsValid() {
        return StringUtils.isNotEmpty((CharSequence)System.getenv(POD_CPU_LIMIT_ENV_VAR)) && StringUtils.isNotEmpty((CharSequence)System.getenv(POD_CPU_REQUEST_ENV_VAR));
    }

    private Supplier<Double> podCpuLimitSupplier() {
        return new Supplier<Double>(){

            public Double get() {
                if (!JMXMetricHandler.this.arePodEnvVarsValid()) {
                    return -1.0;
                }
                String podCpuLimit = System.getenv(JMXMetricHandler.POD_CPU_LIMIT_ENV_VAR);
                double parsedLimit = JMXMetricHandler.this.getFactor(podCpuLimit);
                if (parsedLimit == -1.0) {
                    LOGGER.error("Invalid podCpuLimit value set in the environment: {}. Parsed limit value: {}", (Object)podCpuLimit, (Object)parsedLimit);
                } else {
                    LOGGER.info("Pod Cpu Limit: {}. Parsed limit value: {}", (Object)podCpuLimit, (Object)parsedLimit);
                }
                return parsedLimit;
            }
        };
    }

    private Supplier<Double> podCpuRequestSupplier() {
        return new Supplier<Double>(){

            public Double get() {
                if (!JMXMetricHandler.this.arePodEnvVarsValid()) {
                    return -1.0;
                }
                String podCpuReq = System.getenv(JMXMetricHandler.POD_CPU_REQUEST_ENV_VAR);
                double parsedRequest = JMXMetricHandler.this.getFactor(podCpuReq);
                if (parsedRequest == -1.0) {
                    LOGGER.error("Invalid podCpuReq value set in the environment: {}. Parsed request value: {}", (Object)podCpuReq, (Object)parsedRequest);
                } else {
                    LOGGER.info("Pod Cpu Request Env Var Value: {}. Parsed request value: {}", (Object)podCpuReq, (Object)parsedRequest);
                }
                return parsedRequest;
            }
        };
    }

    private Supplier<Double> podCpuMultiplierSupplier() {
        return new Supplier<Double>(){

            public Double get() {
                int numCores = JMXMetricHandler.this.runtimeNumCoresService.getNumCores();
                double factor = (Double)JMXMetricHandler.this.podCpuLimitSupplier.get();
                if (factor != -1.0) {
                    LOGGER.info("Current pod cpu multiplier value = {}", (Object)((double)numCores / factor));
                    return (double)numCores / factor;
                }
                return -1.0;
            }
        };
    }

    private double getFactor(String podCpuLimit) {
        if (podCpuLimit.contains("m")) {
            return NumberUtils.toDouble((String)podCpuLimit.substring(0, podCpuLimit.indexOf(109)), (double)-1.0) / 1000.0;
        }
        return NumberUtils.toDouble((String)podCpuLimit, (double)-1.0);
    }

    private List<MetricRecord> generateOsMetric(MetricRecord record) {
        List<Tuple<String, String>> tags = record.getTags();
        List<Tuple<String, String>> values = record.getValues();
        ArrayList<MetricRecord> result = new ArrayList<MetricRecord>();
        for (Tuple<String, String> pair : values) {
            String key = (String)JVM_TO_OS_METRIC_CONVERSION_MAP.get((Object)pair.first());
            if (key == null) continue;
            result.add(MetricRecord.create(OPERATING_SYSTEM_METRIC_NAME, tags, Collections.singletonList(Tuple.tuple(key, pair.second()))));
        }
        return result;
    }

    private List<Tuple<String, String>> createSystemMetricTags() {
        EnvironmentProvider commonTagProducer = new EnvironmentProvider(this.configuration, this.configuration.overrideAppId(null));
        ArrayList<Event<Fact>> events = new ArrayList<Event<Fact>>(commonTagProducer.produce());
        ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
        for (Map.Entry<String, String> e : ((Fact)((Event)events.get(0)).getValue()).getDimensionMap().entrySet()) {
            result.add(Tuple.tuple(e.getKey(), e.getValue()));
        }
        return result;
    }

    void writeJsonBatcher() {
        ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).writeBatcher();
    }
}

