/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.geoip2;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mulesoft.analytics.collector.shaded.db.InvalidDatabaseException;
import com.mulesoft.analytics.collector.shaded.db.Metadata;
import com.mulesoft.analytics.collector.shaded.db.NoCache;
import com.mulesoft.analytics.collector.shaded.db.NodeCache;
import com.mulesoft.analytics.collector.shaded.db.Reader;
import com.mulesoft.analytics.collector.shaded.geoip2.DatabaseProvider;
import com.mulesoft.analytics.collector.shaded.geoip2.JsonInjector;
import com.mulesoft.analytics.collector.shaded.geoip2.exception.AddressNotFoundException;
import com.mulesoft.analytics.collector.shaded.geoip2.exception.GeoIp2Exception;
import com.mulesoft.analytics.collector.shaded.geoip2.model.AnonymousIpResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.model.AsnResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.model.CityResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.model.ConnectionTypeResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.model.CountryResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.model.DomainResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.model.EnterpriseResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.model.IspResponse;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;

public class DatabaseReader
implements DatabaseProvider,
Closeable {
    private final Reader reader;
    private final ObjectMapper om;
    private final List<String> locales;

    private DatabaseReader(Builder builder) throws IOException {
        if (builder.stream != null) {
            this.reader = new Reader(builder.stream, builder.cache);
        } else if (builder.database != null) {
            this.reader = new Reader(builder.database, builder.mode, builder.cache);
        } else {
            throw new IllegalArgumentException("Unsupported Builder configuration: expected either File or URL");
        }
        this.om = new ObjectMapper();
        this.om.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, false);
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.om.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        this.locales = builder.locales;
    }

    private <T> T get(InetAddress ipAddress, Class<T> cls, String type) throws IOException, AddressNotFoundException {
        String databaseType = this.getMetadata().getDatabaseType();
        if (!databaseType.contains(type)) {
            String caller = Thread.currentThread().getStackTrace()[2].getMethodName();
            throw new UnsupportedOperationException("Invalid attempt to open a " + databaseType + " database using the " + caller + " method");
        }
        ObjectNode node = this.jsonNodeToObjectNode(this.reader.get(ipAddress));
        if (node == null) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        JsonInjector inject = new JsonInjector(this.locales, ipAddress.getHostAddress());
        return (T)this.om.reader((InjectableValues)inject).treeToValue((TreeNode)node, cls);
    }

    private ObjectNode jsonNodeToObjectNode(JsonNode node) throws InvalidDatabaseException {
        if (node == null || node instanceof ObjectNode) {
            return (ObjectNode)node;
        }
        throw new InvalidDatabaseException("Unexpected data type returned. The GeoIP2 database may be corrupt.");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CountryResponse.class, "Country");
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CityResponse.class, "City");
    }

    @Override
    public AnonymousIpResponse anonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, AnonymousIpResponse.class, "GeoIP2-Anonymous-IP");
    }

    @Override
    public AsnResponse asn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, AsnResponse.class, "GeoLite2-ASN");
    }

    @Override
    public ConnectionTypeResponse connectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, ConnectionTypeResponse.class, "GeoIP2-Connection-Type");
    }

    @Override
    public DomainResponse domain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, DomainResponse.class, "GeoIP2-Domain");
    }

    @Override
    public EnterpriseResponse enterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, EnterpriseResponse.class, "Enterprise");
    }

    @Override
    public IspResponse isp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, IspResponse.class, "GeoIP2-ISP");
    }

    public Metadata getMetadata() {
        return this.reader.getMetadata();
    }

    public static final class Builder {
        final File database;
        final InputStream stream;
        List<String> locales = Collections.singletonList("en");
        Reader.FileMode mode = Reader.FileMode.MEMORY_MAPPED;
        NodeCache cache = NoCache.getInstance();

        public Builder(InputStream stream) {
            this.stream = stream;
            this.database = null;
        }

        public Builder(File database) {
            this.database = database;
            this.stream = null;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder withCache(NodeCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder fileMode(Reader.FileMode val) {
            if (this.stream != null && Reader.FileMode.MEMORY != val) {
                throw new IllegalArgumentException("Only FileMode.MEMORY is supported when using an InputStream.");
            }
            this.mode = val;
            return this;
        }

        public DatabaseReader build() throws IOException {
            return new DatabaseReader(this);
        }
    }
}

