/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.TagValues;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventBatchMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.GroupByKeyReducer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class FactCombiner
extends GroupByKeyReducer<Fact, Fact> {
    public FactCombiner(int maxSize) {
        super(maxSize);
        this.processor = new Transformer();
    }

    private class Transformer
    implements EventBatchMapper<Fact, Fact> {
        private Transformer() {
        }

        @Override
        @Nullable
        public Collection<Event<Fact>> process(Collection<Event<Fact>> events) {
            Fact result = this.mergeFacts(events);
            if (result != null) {
                return Arrays.asList(new Event<long>(events.iterator().next().getTime(), result));
            }
            return null;
        }

        @Nullable
        private Fact mergeFacts(Collection<Event<Fact>> events) {
            if (!this.isComplete(events)) {
                return null;
            }
            Fact result = null;
            for (Event<Fact> event : events) {
                Fact fact = event.getValue();
                if (result == null) {
                    result = new Fact();
                }
                for (Map.Entry<String, String> entry : fact.getDimensionMap().entrySet()) {
                    result.setDimension(entry.getKey(), entry.getValue());
                }
                for (String name : fact.getLongMetrics()) {
                    result.setLongMetric(name, fact.getLongMetric(name));
                }
                for (String name : fact.getDoubleMetrics()) {
                    result.setDoubleMetric(name, fact.getDoubleMetric(name));
                }
                for (Fact.Attribute attr : fact.getAttributes()) {
                    result.setAttribute(attr, fact.getAttribute(attr));
                }
            }
            return result;
        }

        private boolean isComplete(Collection<Event<Fact>> events) {
            Boolean apiGatewayInvolved;
            Event<Fact> preInvoke = null;
            Event<Fact> postInvoke = null;
            Event<Fact> apiGatewayOutcome = null;
            for (Event<Fact> event : events) {
                Fact fact = event.getValue();
                InvocationContext.Action action = (InvocationContext.Action)((Object)fact.getAttribute(Fact.Attribute.ACTION));
                if (action == InvocationContext.Action.PRE_INVOKE && preInvoke == null) {
                    preInvoke = event;
                    continue;
                }
                if (action == InvocationContext.Action.POST_INVOKE_SUCCESS || action == InvocationContext.Action.POST_INVOKE_ERROR) {
                    postInvoke = event;
                    continue;
                }
                if (action != InvocationContext.Action.PROCESSED_API_GATEWAY_EVENT && action != InvocationContext.Action.BLOCKED_API_GATEWAY_EVENT) continue;
                apiGatewayOutcome = event;
            }
            if (!(preInvoke == null || postInvoke == null || (apiGatewayInvolved = (Boolean)((Fact)postInvoke.getValue()).getAttribute(Fact.Attribute.API_GATEWAY_INVOLVED)) != null && apiGatewayInvolved.booleanValue() && apiGatewayOutcome == null)) {
                if (apiGatewayOutcome != null && InvocationContext.Action.BLOCKED_API_GATEWAY_EVENT == ((Fact)apiGatewayOutcome.getValue()).getAttribute(Fact.Attribute.ACTION)) {
                    FactCombiner.this.evictKey(apiGatewayOutcome.getGroupingKey());
                    return false;
                }
                if (((Fact)postInvoke.getValue()).getAttribute(Fact.Attribute.ACTION) == InvocationContext.Action.POST_INVOKE_SUCCESS) {
                    postInvoke.getValue().setDimension("response_type", TagValues.OK.name());
                } else {
                    postInvoke.getValue().setDimension("response_type", TagValues.FAILED.name());
                }
                postInvoke.getValue().setLongMetric("response_time", Math.max(postInvoke.getTime() - preInvoke.getTime(), 0L));
                return true;
            }
            return false;
        }
    }
}

