/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.AsyncProcessor;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Step;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduledProducer<O>
extends Step<Void, O> {
    private static final Logger LOGGER = LogManager.getLogger(AsyncProcessor.class);
    private final EventProducer<O> eventProducer;
    private final ScheduledExecutorService executor;
    private final int delayInMS;
    private final int periodInMS;
    private final boolean produceOnStop;
    @Nullable
    private Future<?> scheduledTask;

    public ScheduledProducer(EventProducer<O> eventProducer, ScheduledExecutorService executor, int delayInMS, int periodInMS, boolean produceOnStop) {
        this.eventProducer = eventProducer;
        this.executor = executor;
        this.delayInMS = delayInMS;
        this.periodInMS = periodInMS;
        this.produceOnStop = produceOnStop;
    }

    @Override
    protected void process(Event<Void> event) {
    }

    private void produce() {
        try {
            for (Event<O> event : this.eventProducer.produce()) {
                this.nextProcess(event);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception inside ScheduledProducer thread", (Throwable)e);
        }
    }

    @Override
    public void start() {
        this.scheduledTask = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ScheduledProducer.this.produce();
            }
        }, this.delayInMS, this.periodInMS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.produceOnStop) {
            this.produce();
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
            this.scheduledTask = null;
        }
    }
}

