/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.db;

import com.mulesoft.analytics.collector.shaded.db.Reader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class BufferHolder {
    private final ByteBuffer buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferHolder(File database, Reader.FileMode mode) throws IOException {
        RandomAccessFile file = new RandomAccessFile(database, "r");
        boolean threw = true;
        try {
            FileChannel channel = file.getChannel();
            if (mode == Reader.FileMode.MEMORY) {
                this.buffer = ByteBuffer.wrap(new byte[(int)channel.size()]);
                if (channel.read(this.buffer) != this.buffer.capacity()) {
                    throw new IOException("Unable to read " + database.getName() + " into memory. Unexpected end of stream.");
                }
            } else {
                this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            }
            threw = false;
        }
        finally {
            block11: {
                try {
                    file.close();
                }
                catch (IOException e) {
                    if (threw) break block11;
                    throw e;
                }
            }
        }
    }

    BufferHolder(InputStream stream) throws IOException {
        int br;
        if (null == stream) {
            throw new NullPointerException("Unable to use a NULL InputStream");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[16384];
        while (-1 != (br = stream.read(bytes))) {
            baos.write(bytes, 0, br);
        }
        this.buffer = ByteBuffer.wrap(baos.toByteArray());
    }

    BufferHolder(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    synchronized ByteBuffer get() {
        return this.buffer.duplicate();
    }
}

