/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.log;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.util.Strings;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class MetricRecord {
    private long time = -1L;
    private final String name;
    private final List<Tuple<String, String>> tags = new ArrayList<Tuple<String, String>>();
    private final List<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
    private static final String SEPARATOR = ",";
    private static final String EQ = "=";

    public MetricRecord(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder line = new StringBuilder();
        line.append(this.name);
        if (!this.tags.isEmpty()) {
            line.append(SEPARATOR);
            this.dumpList(line, this.tags);
        }
        if (!this.values.isEmpty()) {
            line.append(" ");
            this.dumpList(line, this.values);
        }
        line.append(" ").append(this.time >= 0L ? this.time : System.currentTimeMillis());
        return line.toString();
    }

    private void dumpList(StringBuilder line, List<Tuple<String, String>> list) {
        for (int i = 0; i < list.size(); ++i) {
            Tuple<String, String> tuple = list.get(i);
            line.append(Strings.normalize(tuple.first())).append(EQ).append(Strings.normalize(tuple.second()));
            if (i >= list.size() - 1) continue;
            line.append(SEPARATOR);
        }
    }

    public static MetricRecord create(String name, List<Tuple<String, String>> tags, List<Tuple<String, String>> values) {
        MetricRecord metricRecord = new MetricRecord(name);
        metricRecord.tags.addAll(tags);
        metricRecord.values.addAll(values);
        return metricRecord;
    }

    public static MetricRecord create(String name, List<Tuple<String, String>> tags, List<Tuple<String, String>> values, long time) {
        MetricRecord metricRecord = MetricRecord.create(name, tags, values);
        metricRecord.time = time;
        return metricRecord;
    }

    public static MetricRecord convert(String metricType, Event<Fact> event) {
        Tuple<String, String> tag;
        Fact fact = event.getValue();
        ArrayList<Tuple<String, String>> tags = new ArrayList<Tuple<String, String>>();
        for (Map.Entry<String, String> entry : fact.getDimensionMap().entrySet()) {
            String dimension = entry.getKey();
            String dimensionValue = entry.getValue();
            Tuple<String, String> tag2 = Tuple.tuple(dimension, dimensionValue);
            tags.add(tag2);
        }
        ArrayList<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
        for (String metric : fact.getLongMetrics()) {
            tag = Tuple.tuple(metric, Long.toString((Long)ObjectUtils.defaultIfNull((Object)fact.getLongMetric(metric), (Object)0L)));
            values.add(tag);
        }
        for (String metric : fact.getDoubleMetrics()) {
            tag = Tuple.tuple(metric, Double.toString((Double)ObjectUtils.defaultIfNull((Object)fact.getDoubleMetric(metric), (Object)0.0)));
            values.add(tag);
        }
        return MetricRecord.create(metricType, tags, values, event.getTime());
    }

    public String getName() {
        return this.name;
    }

    public List<Tuple<String, String>> getTags() {
        return this.tags;
    }

    public List<Tuple<String, String>> getValues() {
        return this.values;
    }
}

