/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mulesoft.analytics.collector.metrics.BatcherSettings;
import com.mulesoft.analytics.collector.metrics.MetricEvent;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MetricEventUtils {
    private MetricEventUtils() {
    }

    public static MetricEvent convert(FactMeta factMeta, Event<Fact> event, ImmutableMap<String, BatcherSettings> batcherSettingsMap) {
        Fact fact = event.getValue();
        BatcherSettings batcherSettings = (BatcherSettings)batcherSettingsMap.get((Object)factMeta.getName());
        boolean nested = batcherSettings != null && batcherSettings.isNested();
        ImmutableSet<String> configuredCommons = batcherSettings != null ? batcherSettings.getCommonsSettings() : ImmutableSet.of();
        ImmutableSet<String> configuredForceEvents = batcherSettings != null ? batcherSettings.getForceEventsSettings() : ImmutableSet.of();
        String customMetricName = null;
        HashMap<String, String> commons = new HashMap<String, String>();
        HashMap<String, Object> eventValues = new HashMap<String, Object>();
        HashMap<String, String> customDimensions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fact.getDimensionMap().entrySet()) {
            String dimension = entry.getKey();
            String dimensionValue = entry.getValue();
            if (configuredCommons.contains((Object)dimension)) {
                commons.put(dimension, dimensionValue);
            } else if ("metric_name".equals(dimension)) {
                customMetricName = dimensionValue;
                if (factMeta.getName().equals("system_metric")) {
                    eventValues.put("metric_name", customMetricName);
                }
            } else if (nested) {
                customDimensions.put(dimension, dimensionValue);
            } else if (factMeta.getRetainingDimensions().contains((Object)dimension) || factMeta.getCollapsibleDimensions().contains((Object)dimension) || dimension.startsWith("base64.") || dimension.startsWith("viz.")) {
                eventValues.put(dimension, dimensionValue);
            }
            if (!configuredForceEvents.contains((Object)dimension)) continue;
            eventValues.put(dimension, dimensionValue);
        }
        for (String metric : fact.getLongMetrics()) {
            if (!factMeta.getLongMetrics().contains((Object)StringUtils.substringBefore((String)metric, (String)"."))) continue;
            eventValues.put(metric, ObjectUtils.defaultIfNull((Object)fact.getLongMetric(metric), (Object)0L));
        }
        for (String metric : fact.getDoubleMetrics()) {
            if (!factMeta.getDoubleMetrics().contains((Object)StringUtils.substringBefore((String)metric, (String)"."))) continue;
            eventValues.put(metric, ObjectUtils.defaultIfNull((Object)fact.getDoubleMetric(metric), (Object)0.0));
        }
        return nested ? new MetricEvent(event.getTime(), factMeta.getName(), fact.isAggregated(), fact.isLimited(), commons, eventValues, customDimensions, customMetricName) : new MetricEvent(event.getTime(), factMeta.getName(), fact.isAggregated(), fact.isLimited(), commons, eventValues);
    }
}

