/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.google.common.base.CaseFormat;
import javax.annotation.Nullable;

public enum NodeType {
    MULE("mule", "mule", "Mule"),
    HTTP("http", "http", "Http"),
    DB("db", "db", "Database"),
    SFDC("salesforce", "salesforce", "Salesforce"),
    OS("os", "objectstore", "Objectstore"),
    OBJECTSTORE("objectstore", "objectstore", "Objectstore"),
    ANYPOINT_MQ("anypoint-mq", "anypoint-mq", "AnypointMQ"),
    MESSAGING_MQ("messaging.mq", "anypoint-mq", "AnypointMQ"),
    OTHER("", "other", "Other");

    private final String namespace;
    private final String processorName;
    private final String hostName;

    private NodeType(String namespace, String processorName, String hostName) {
        this.namespace = namespace;
        this.processorName = processorName;
        this.hostName = hostName;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public static NodeType getTypeFromProcessor(@Nullable String processor) {
        for (NodeType nodeType : NodeType.values()) {
            if (!nodeType.namespace.equalsIgnoreCase(processor)) continue;
            return nodeType;
        }
        return OTHER;
    }

    public String getHostNameFromType(@Nullable String processor) {
        if (this == OTHER && processor != null) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, processor.toLowerCase());
        }
        return this.getHostName();
    }
}

