/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.db;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Metadata {
    private final int binaryFormatMajorVersion;
    private final int binaryFormatMinorVersion;
    private final long buildEpoch;
    private final String databaseType;
    private final JsonNode description;
    private final int ipVersion;
    private final JsonNode languages;
    private final int nodeByteSize;
    private final int nodeCount;
    private final int recordSize;
    private final int searchTreeSize;

    Metadata(JsonNode metadata) {
        this.binaryFormatMajorVersion = metadata.get("binary_format_major_version").asInt();
        this.binaryFormatMinorVersion = metadata.get("binary_format_minor_version").asInt();
        this.buildEpoch = metadata.get("build_epoch").asLong();
        this.databaseType = metadata.get("database_type").asText();
        this.languages = metadata.get("languages");
        this.description = metadata.get("description");
        this.ipVersion = metadata.get("ip_version").asInt();
        this.nodeCount = metadata.get("node_count").asInt();
        this.recordSize = metadata.get("record_size").asInt();
        this.nodeByteSize = this.recordSize / 4;
        this.searchTreeSize = this.nodeCount * this.nodeByteSize;
    }

    public int getBinaryFormatMajorVersion() {
        return this.binaryFormatMajorVersion;
    }

    public int getBinaryFormatMinorVersion() {
        return this.binaryFormatMinorVersion;
    }

    public Date getBuildDate() {
        return new Date(this.buildEpoch * 1000L);
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, String> getDescription() {
        return (Map)new ObjectMapper().convertValue((Object)this.description, new TypeReference<HashMap<String, String>>(){});
    }

    public int getIpVersion() {
        return this.ipVersion;
    }

    public List<String> getLanguages() {
        return (List)new ObjectMapper().convertValue((Object)this.languages, new TypeReference<ArrayList<String>>(){});
    }

    int getNodeByteSize() {
        return this.nodeByteSize;
    }

    int getNodeCount() {
        return this.nodeCount;
    }

    int getRecordSize() {
        return this.recordSize;
    }

    int getSearchTreeSize() {
        return this.searchTreeSize;
    }

    public String toString() {
        return "Metadata [binaryFormatMajorVersion=" + this.binaryFormatMajorVersion + ", binaryFormatMinorVersion=" + this.binaryFormatMinorVersion + ", buildEpoch=" + this.buildEpoch + ", databaseType=" + this.databaseType + ", description=" + this.description + ", ipVersion=" + this.ipVersion + ", nodeCount=" + this.nodeCount + ", recordSize=" + this.recordSize + "]";
    }
}

