/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.abp.CorePricingStatsProvider;
import com.mulesoft.analytics.collector.config.Configuration;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;
import org.mule.runtime.core.api.management.stats.ResetOnQueryCounter;

public class CorePricingStatsProviderImpl
implements CorePricingStatsProvider {
    private static final Logger LOGGER = LogManager.getLogger(CorePricingStatsProviderImpl.class);
    @Nullable
    private FlowConstructStatistics appStats = null;
    @Nullable
    private FlowsSummaryStatistics flowsSummaryStatistics = null;
    @Nullable
    ResetOnQueryCounter eventsReceivedCounter = null;
    @Nullable
    ResetOnQueryCounter publicUsageCounter = null;
    private boolean isEnabled = false;

    public CorePricingStatsProviderImpl(MuleContext muleContext, Configuration configuration) {
        if (!configuration.isCorePricingMeteringEnabled()) {
            LOGGER.error("Core Pricing in mule4 is disabled explicitly via metering configuration.");
            return;
        }
        String rootOrgId = configuration.getMasterOrgId();
        if (rootOrgId == null) {
            LOGGER.error("Core Pricing in mule4 is disabled due to missing root_org_id configuration.");
            return;
        }
        String assetId = configuration.getCorePricingAssetId();
        if (assetId.isEmpty()) {
            LOGGER.error("Core Pricing in mule4 is disabled due to missing asset_id configuration.");
            return;
        }
        AllStatistics allStats = muleContext.getStatistics();
        if (allStats == null) {
            LOGGER.error("Core Pricing in mule4 is disabled due to null AllStatistics");
            return;
        }
        this.appStats = allStats.getApplicationStatistics();
        if (this.appStats == null) {
            LOGGER.error("Core Pricing in mule4 is disabled due to null ApplicationStatistics");
            return;
        }
        if (!this.appStats.isEnabled()) {
            LOGGER.error("Core Pricing in mule4 is disabled due to disabled ApplicationStatistics");
            return;
        }
        try {
            this.flowsSummaryStatistics = allStats.getFlowSummaryStatistics();
            if (this.flowsSummaryStatistics == null) {
                LOGGER.error("Core Pricing in mule4 is disabled due to null FlowsSummaryStatistics");
                return;
            }
            if (!this.flowsSummaryStatistics.isEnabled()) {
                LOGGER.error("Core Pricing in mule4 is disabled due to disabled FlowsSummaryStatistics");
                return;
            }
            this.eventsReceivedCounter = this.appStats.getEventsReceivedCounter();
            if (this.eventsReceivedCounter == null) {
                LOGGER.error("Core Pricing in mule4 is disabled due to null Usage Counter");
                return;
            }
            this.publicUsageCounter = this.appStats.getDispatchedMessagesCounter();
            if (this.publicUsageCounter == null) {
                LOGGER.error("Core Pricing in mule4 is disabled due to null Public Usage Counter");
            }
        }
        catch (NoSuchMethodError e) {
            LOGGER.error("Core Pricing in mule4 is disabled due to method not found: " + e);
            return;
        }
        this.isEnabled = true;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public long getFlowCount() {
        if (this.flowsSummaryStatistics != null) {
            return this.flowsSummaryStatistics.getDeclaredTriggerFlows() + this.flowsSummaryStatistics.getDeclaredApikitFlows();
        }
        return 0L;
    }

    @Override
    public long getPublicUsageCount() {
        if (this.publicUsageCounter != null) {
            return this.publicUsageCounter.getAndReset();
        }
        return 0L;
    }

    @Override
    public long getUsageCount() {
        if (this.eventsReceivedCounter != null) {
            return this.eventsReceivedCounter.getAndReset();
        }
        return 0L;
    }
}

