/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.geoip2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mulesoft.analytics.collector.shaded.geoip2.model.AbstractCountryResponse;
import com.mulesoft.analytics.collector.shaded.geoip2.record.City;
import com.mulesoft.analytics.collector.shaded.geoip2.record.Continent;
import com.mulesoft.analytics.collector.shaded.geoip2.record.Country;
import com.mulesoft.analytics.collector.shaded.geoip2.record.Location;
import com.mulesoft.analytics.collector.shaded.geoip2.record.MaxMind;
import com.mulesoft.analytics.collector.shaded.geoip2.record.Postal;
import com.mulesoft.analytics.collector.shaded.geoip2.record.RepresentedCountry;
import com.mulesoft.analytics.collector.shaded.geoip2.record.Subdivision;
import com.mulesoft.analytics.collector.shaded.geoip2.record.Traits;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCityResponse
extends AbstractCountryResponse {
    private final City city;
    private final Location location;
    private final Postal postal;
    private final List<Subdivision> subdivisions;

    AbstractCityResponse() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    AbstractCityResponse(City city, Continent continent, Country country, Location location, MaxMind maxmind, Postal postal, Country registeredCountry, RepresentedCountry representedCountry, List<Subdivision> subdivisions, Traits traits) {
        super(continent, country, maxmind, registeredCountry, representedCountry, traits);
        this.city = city != null ? city : new City();
        this.location = location != null ? location : new Location();
        this.postal = postal != null ? postal : new Postal();
        this.subdivisions = subdivisions != null ? subdivisions : new ArrayList();
    }

    public City getCity() {
        return this.city;
    }

    public Location getLocation() {
        return this.location;
    }

    public Postal getPostal() {
        return this.postal;
    }

    public List<Subdivision> getSubdivisions() {
        return new ArrayList<Subdivision>(this.subdivisions);
    }

    @JsonIgnore
    public Subdivision getMostSpecificSubdivision() {
        if (this.subdivisions.isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions.get(this.subdivisions.size() - 1);
    }

    @JsonIgnore
    public Subdivision getLeastSpecificSubdivision() {
        if (this.subdivisions.isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions.get(0);
    }
}

