/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.util;

import javax.annotation.Nullable;

public final class HttpUtils {
    public static final String HOST_HEADER = "host";
    public static final String X_FORWARD_IP_HEADER = "x-forwarded-for";
    public static final String X_FORWARD_PROTO_HEADER = "x-forwarded-proto";

    private HttpUtils() {
    }

    public static boolean isErrorStatusCode(int statusCode) {
        return statusCode < 200 || statusCode > 399;
    }

    @Nullable
    public static String parseHttpRemoteAddress(@Nullable String addr) {
        int start;
        if (addr == null) {
            return null;
        }
        int end = addr.lastIndexOf(58);
        if (end < 0) {
            end = addr.length();
        }
        int n = start = (start = addr.lastIndexOf(47, end)) >= 0 ? start + 1 : 0;
        if (start < end) {
            return addr.substring(start, end);
        }
        return null;
    }

    @Nullable
    public static String extractBasePath(@Nullable String path) {
        if (path != null) {
            String basePath = path;
            int asteriskIndex = path.indexOf("*");
            int bracketIndex = path.indexOf("{");
            if (asteriskIndex >= 0 || bracketIndex >= 0) {
                int i = bracketIndex == -1 || asteriskIndex >= 0 && asteriskIndex < bracketIndex ? asteriskIndex : bracketIndex;
                basePath = path.substring(0, i);
            }
            if (basePath.endsWith("/")) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            return basePath;
        }
        return null;
    }
}

