/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.MoreObjects;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.util.Maps;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Singleton
public class YamlApplicationPropertiesService {
    private static final Logger LOGGER = LogManager.getLogger(YamlApplicationPropertiesService.class);
    private static final String SERVICES = "services";
    private static final String APP_PROP_SERVICE = "mule.agent.application.properties.service";
    private static final String APP_PROP_CONFIGS = "applicationPropertiesConfigurations";
    private static final String APP_NAME = "applicationName";
    private static final String PROPERTIES = "properties";
    @Inject
    private Configuration configuration;

    public Properties getPropertiesForApplication(String appName) {
        Properties properties = new Properties();
        Path confPath = this.configuration.getMuleHome().resolve("conf");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(confPath, "*.yml");){
            for (Path path : stream) {
                properties.putAll(this.readAppProperties(appName, path));
            }
        }
        catch (IOException e) {
            LOGGER.info("Failed to read yml files from directory. Skipped.");
        }
        return properties;
    }

    private Map<String, String> readAppProperties(String appName, Path ymlFile) throws IOException {
        HashMap<String, String> results = new HashMap<String, String>();
        String ymlContent = new String(Files.readAllBytes(ymlFile));
        Yaml yaml = new Yaml();
        Map contentMap = Maps.emptyIfNull((Map)yaml.load(ymlContent));
        Map servicesMap = Maps.emptyIfNull((Map)contentMap.get(SERVICES));
        Map appPropSvcMap = Maps.emptyIfNull((Map)servicesMap.get(APP_PROP_SERVICE));
        List appPropMaps = (List)MoreObjects.firstNonNull((Object)((List)appPropSvcMap.get(APP_PROP_CONFIGS)), Collections.emptyList());
        for (Map appPropMap : appPropMaps) {
            String name = (String)appPropMap.get(APP_NAME);
            if (!appName.equals(name)) continue;
            Map propsMap = Maps.emptyIfNull((Map)appPropMap.get(PROPERTIES));
            for (Map.Entry entry : propsMap.entrySet()) {
                results.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return results;
    }
}

