/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.NodeType;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventCorrelator;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.pipeline.EventPipelineInfo;
import com.mulesoft.analytics.collector.util.HttpUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.context.notification.ConnectorMessageNotificationListener;
import org.mule.api.source.MessageSource;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.modules.oauth2.provider.token.AccessTokenStoreHolder;

public class ConnectorNotificationListener
extends AbstractListener
implements ConnectorMessageNotificationListener<ConnectorMessageNotification> {
    static final String API_GATEWAY_HTTP_EVENT = "__httpEvent";
    private static final Logger LOGGER = LogManager.getLogger(ConnectorNotificationListener.class);
    private static final Set<String> SUPPORTED_PROTOCOLS = ImmutableSet.of((Object)"http", (Object)"https");
    private final EventPipeline<NotificationEnvelope> inboundMetricPipeline;
    private final EventCorrelator inboundEventCorrelator;
    private final EventPipeline<NotificationEnvelope> outboundMetricPipeline;

    public ConnectorNotificationListener(Configuration configuration, MuleContext muleContext, PipelineRegistry pipelineRegistry, String appId) {
        this(configuration, muleContext, pipelineRegistry, appId, null);
    }

    public ConnectorNotificationListener(Configuration configuration, MuleContext muleContext, PipelineRegistry pipelineRegistry, String appId, @Nullable Supplier<List<String>> endpointTemplateSupplier) {
        super(configuration, muleContext);
        EventPipelineInfo<NotificationEnvelope> inboundMetricPipelineInfo = pipelineRegistry.createInboundPipelineInfo(appId, new InboundNotificationTransformer(), endpointTemplateSupplier);
        this.inboundMetricPipeline = inboundMetricPipelineInfo.getPipeline();
        this.inboundEventCorrelator = inboundMetricPipelineInfo.getCorrelator();
        this.outboundMetricPipeline = pipelineRegistry.createOutboundPipeline(appId, new OutboundNotificationTransformer());
    }

    public void onNotification(ConnectorMessageNotification notification) {
        LOGGER.debug("ConnectorMessageNotification: {}", (Object)notification);
        int action = notification.getAction();
        if (action == 801 || action == 805 || action == 806) {
            String correlationId;
            String messageId = notification.getSource().getUniqueId();
            if (action != 801 && (correlationId = notification.getSource().getCorrelationId()) != null && !messageId.equals(correlationId = this.trimInvocationId(correlationId)) && !this.inboundEventCorrelator.containsEventWithGroupingKey(messageId)) {
                messageId = correlationId;
            }
            boolean isApiGatewayInvolved = notification.getSource().getInvocationProperty(API_GATEWAY_HTTP_EVENT) != null;
            NotificationEnvelope envelope = new NotificationEnvelope(notification, messageId, isApiGatewayInvolved);
            this.inboundMetricPipeline.submit(new Event<NotificationEnvelope>(envelope));
        } else if (action == 804) {
            NotificationEnvelope envelope = new NotificationEnvelope(notification, ConnectorNotificationListener.generateOutboundInvocationId(notification.getSource().getUniqueId()), false);
            this.outboundMetricPipeline.submit(new Event<NotificationEnvelope>(envelope));
        }
    }

    boolean resolveConnector(InvocationContext context, ConnectorMessageNotification notification) {
        FlowConstruct flowConstruct = notification.getFlowConstruct();
        if (flowConstruct instanceof Pipeline) {
            MessageSource messageSource = ((Pipeline)flowConstruct).getMessageSource();
            if (messageSource instanceof HttpListener || !this.resolveType(context, messageSource, false)) {
                context.setConnector(NodeType.HTTP.getProcessorName());
                if (messageSource instanceof HttpListener) {
                    context.setBasePath(HttpUtils.extractBasePath(((HttpListener)messageSource).getPath()));
                }
                return true;
            }
        } else {
            context.setConnector(NodeType.HTTP.getProcessorName());
            return true;
        }
        return false;
    }

    private class OutboundNotificationTransformer
    implements EventMapper<NotificationEnvelope, InvocationContext> {
        private OutboundNotificationTransformer() {
        }

        @Override
        public Collection<Event<InvocationContext>> process(Event<NotificationEnvelope> event) {
            ConnectorMessageNotification notification = event.getValue().notification;
            URI uri = this.resolveURI(notification);
            if (uri == null) {
                LOGGER.debug("Unsupported connector from endpoint: {}", (Object)notification.getEndpoint());
                return Collections.emptyList();
            }
            InvocationContext result = new InvocationContext();
            result.setInvocationId(event.getValue().invocationId);
            result.setProtocol(uri.getScheme().toLowerCase());
            result.setRemoteHost(uri.getHost());
            result.setRemotePort(Integer.toString(uri.getPort()));
            result.setEndpoint(uri.getPath());
            LOGGER.debug("Outbound invocation: {}", (Object)result);
            return Collections.singleton(new Event<long>(notification.getTimestamp(), result));
        }

        @Nullable
        private URI resolveURI(ConnectorMessageNotification notification) {
            URI endpoint;
            try {
                endpoint = new URI(notification.getEndpoint());
            }
            catch (URISyntaxException e) {
                return null;
            }
            if (endpoint.getScheme() == null) {
                return null;
            }
            if (!SUPPORTED_PROTOCOLS.contains(endpoint.getScheme().toLowerCase())) {
                return null;
            }
            return endpoint;
        }
    }

    private class InboundNotificationTransformer
    implements EventMapper<NotificationEnvelope, InvocationContext> {
        private InboundNotificationTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Event<InvocationContext>> process(Event<NotificationEnvelope> event) {
            NotificationEnvelope envelope = event.getValue();
            ConnectorMessageNotification notification = envelope.notification;
            MuleMessage message = notification.getSource();
            try {
                InvocationContext.Action action;
                switch (notification.getAction()) {
                    case 801: {
                        action = InvocationContext.Action.PRE_INVOKE;
                        break;
                    }
                    case 805: {
                        action = this.isHttpFailure(message) ? InvocationContext.Action.POST_INVOKE_ERROR : InvocationContext.Action.POST_INVOKE_SUCCESS;
                        break;
                    }
                    case 806: {
                        action = InvocationContext.Action.POST_INVOKE_ERROR;
                        break;
                    }
                    default: {
                        LOGGER.debug("Unsupported action: {}", (Object)notification.getAction());
                        List<Event<InvocationContext>> list = Collections.emptyList();
                        return list;
                    }
                }
                InvocationContext ic = new InvocationContext();
                ic.setInvocationId(envelope.invocationId);
                ConnectorNotificationListener.this.resolveConnector(ic, notification);
                ic.setAction(action);
                ic.setFlowName(notification.getResourceIdentifier());
                ic.setProtocol(this.resolveProtocol(message));
                ic.setRemoteHost(this.resolveRemoteIp(message));
                ic.setClientId(this.resolveClientId(message));
                ic.setHostHeader(ConnectorNotificationListener.this.resolveHostHeader(message));
                ic.setEndpoint(ConnectorNotificationListener.this.resolveRequestPath(message));
                ic.setSourceHash(this.getInboundPropertyAsString(message, "x-anypnt-app-worker"));
                ic.setApiGatewayInvolved(envelope.isApiGatewayInvolved);
                LOGGER.debug("Inbound invocation: {}", (Object)ic);
                Set<Event<InvocationContext>> set = Collections.singleton(new Event<long>(notification.getTimestamp(), ic));
                return set;
            }
            finally {
                AbstractListener.resetAccess(message);
            }
        }

        @Nullable
        private String getInboundPropertyAsString(MuleMessage message, String prop) {
            Object value = message.getInboundProperty(prop);
            return value == null ? null : value.toString();
        }

        @Nullable
        private String resolveProtocol(MuleMessage message) {
            Object scheme;
            String protocol = null;
            String xForwardedProtoHeader = this.getInboundPropertyAsString(message, "x-forwarded-proto");
            if (xForwardedProtoHeader != null) {
                LOGGER.debug("Found {} header: {}", (Object)"x-forwarded-proto", (Object)xForwardedProtoHeader);
                protocol = xForwardedProtoHeader.toLowerCase();
            }
            if (protocol == null && (scheme = message.getInboundProperty("http.scheme")) != null) {
                protocol = scheme.toString().toLowerCase();
            }
            return protocol;
        }

        @Nullable
        private String resolveRemoteIp(MuleMessage message) {
            String remoteIp = null;
            String xForwardedIpHeader = this.getInboundPropertyAsString(message, "x-forwarded-for");
            if (xForwardedIpHeader != null) {
                LOGGER.debug("Found {} header: {}", (Object)"x-forwarded-for", (Object)xForwardedIpHeader);
                remoteIp = xForwardedIpHeader;
            } else {
                Object remoteAddr = message.getInboundProperty("http.remote.address");
                if (remoteAddr != null) {
                    remoteIp = HttpUtils.parseHttpRemoteAddress(remoteAddr.toString());
                }
            }
            return remoteIp;
        }

        private String resolveClientId(MuleMessage message) {
            String clientId = (String)message.getInvocationProperty("_clientId");
            if (clientId != null) {
                LOGGER.debug("Client-Id found via client_id property: {}", (Object)clientId);
            } else {
                AccessTokenStoreHolder accessTokenStoreHolder = (AccessTokenStoreHolder)message.getInvocationProperty("mule.oauth2.access_token_store_holder");
                if (accessTokenStoreHolder != null && accessTokenStoreHolder.getAccessToken() != null) {
                    clientId = accessTokenStoreHolder.getAccessToken().getClientId();
                    LOGGER.debug("Client-Id found via token store property: {}", (Object)clientId);
                }
            }
            return clientId;
        }

        private boolean isHttpFailure(MuleMessage message) {
            Object httpStatus = message.getOutboundProperty("http.status");
            long code = 0L;
            if (httpStatus instanceof Number) {
                code = ((Number)httpStatus).longValue();
            } else if (httpStatus instanceof String) {
                code = NumberUtils.toLong((String)((String)httpStatus), (long)0L);
            }
            return code >= 400L;
        }
    }

    static class NotificationEnvelope {
        final ConnectorMessageNotification notification;
        final String invocationId;
        boolean isApiGatewayInvolved;

        NotificationEnvelope(ConnectorMessageNotification notification, String invocationId, boolean isApiGatewayInvolved) {
            this.notification = notification;
            this.invocationId = invocationId;
            this.isApiGatewayInvolved = isApiGatewayInvolved;
        }
    }
}

