/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncDispatcher<L> {
    private static final Logger LOGGER = LogManager.getLogger(AsyncDispatcher.class);
    private final ExecutorService executor;
    private final Set<L> listeners = Sets.newConcurrentHashSet();
    private final L dispatchingProxy;

    public AsyncDispatcher(Class<L> listenerType) {
        this.executor = Executors.newSingleThreadExecutor();
        this.dispatchingProxy = this.createDispatchingProxy(listenerType);
    }

    public void addListener(L listener) {
        this.listeners.add(listener);
    }

    public void close() {
        this.executor.shutdown();
        this.listeners.clear();
    }

    public L getDispatchingProxy() {
        return this.dispatchingProxy;
    }

    private L createDispatchingProxy(final Class<L> type) {
        return (L)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, final Method method, final Object[] args) {
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new UnsupportedOperationException("Proxy does not support non-void return types");
                }
                AsyncDispatcher.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (Object listener : AsyncDispatcher.this.listeners) {
                            try {
                                method.invoke(listener, args);
                            }
                            catch (Exception e) {
                                LOGGER.error("Exception in listener " + type.getSimpleName(), (Throwable)e);
                            }
                        }
                    }
                });
                return null;
            }
        });
    }
}

