/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.digests;

import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.CryptoServicePurpose;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.digests.KeccakDigest;

/*
 * Exception performing whole class analysis ignored.
 * Exception performing whole class analysis ignored.
 */
public class SHA3Digest
extends KeccakDigest {
    private static int checkBitLength(int n) {
        switch (n) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n + " not supported for SHA-3");
    }

    public SHA3Digest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public SHA3Digest(CryptoServicePurpose cryptoServicePurpose) {
        this(256, cryptoServicePurpose);
    }

    public SHA3Digest(int n) {
        super(SHA3Digest.checkBitLength((int)n), CryptoServicePurpose.ANY);
    }

    public SHA3Digest(int n, CryptoServicePurpose cryptoServicePurpose) {
        super(SHA3Digest.checkBitLength((int)n), cryptoServicePurpose);
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super((KeccakDigest)sHA3Digest);
    }

    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    public int doFinal(byte[] byArray, int n) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n);
    }

    protected int doFinal(byte[] byArray, int n, byte by, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n3 = by & (1 << n2) - 1 | 2 << n2;
        int n4 = n2 + 2;
        if (n4 >= 8) {
            this.absorb((byte)n3);
            n4 -= 8;
            n3 >>>= 8;
        }
        return super.doFinal(byArray, n, (byte)n3, n4);
    }
}

