/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.lms;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.Digest;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.digests.SHA256Digest;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.digests.SHAKEDigest;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.lms.LMSigParameters;

/*
 * Exception performing whole class analysis ignored.
 * Exception performing whole class analysis ignored.
 */
class DigestUtil {
    DigestUtil() {
    }

    static Digest getDigest(LMOtsParameters lMOtsParameters) {
        return DigestUtil.createDigest((ASN1ObjectIdentifier)lMOtsParameters.getDigestOID(), (int)lMOtsParameters.getN());
    }

    static Digest getDigest(LMSigParameters lMSigParameters) {
        return DigestUtil.createDigest((ASN1ObjectIdentifier)lMSigParameters.getDigestOID(), (int)lMSigParameters.getM());
    }

    private static Digest createDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        Digest digest = DigestUtil.createDigest((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (NISTObjectIdentifiers.id_shake256_len.equals(aSN1ObjectIdentifier) || digest.getDigestSize() != n) {
            return new WrapperDigest(digest, n);
        }
        return digest;
    }

    private static Digest createDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake256_len)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException("unrecognized digest OID: " + String.valueOf(aSN1ObjectIdentifier));
    }
}

