/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.cmce;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1Set;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.interfaces.CMCEKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.spec.CMCEParameterSpec;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Arrays;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCCMCEPrivateKey
implements PrivateKey,
CMCEKey {
    private static final long serialVersionUID = 1L;
    private transient CMCEPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCCMCEPrivateKey(CMCEPrivateKeyParameters cMCEPrivateKeyParameters) {
        this.params = cMCEPrivateKeyParameters;
    }

    public BCCMCEPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (CMCEPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCCMCEPrivateKey) {
            BCCMCEPrivateKey bCCMCEPrivateKey = (BCCMCEPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCCMCEPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.params, (ASN1Set)this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public CMCEParameterSpec getParameterSpec() {
        return CMCEParameterSpec.fromName((String)this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    CMCEPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

