/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.processor;

import com.mulesoft.analytics.limiter.AdaptiveConfig;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.StrategyType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class ImmutableEventProcessorConfig
implements EventProcessorConfig,
Serializable {
    private static final long serialVersionUID = -1385670428803312921L;
    final int maxOutput;
    final int samplingSize;
    final int containerSize;
    final double distributionBound;
    final StrategyType strategy;
    final NamePath[] retainingDims;
    final NamePath[] collapsibleDims;
    final NamePath[] longMetricDims;
    final NamePath[] doubleMetricDims;

    public ImmutableEventProcessorConfig(int maxOutput, int samplingSize, int containerSize, double distributionBound, StrategyType strategy, NamePath[] retainingDims, NamePath[] collapsibleDims, NamePath[] longMetricDims, NamePath[] doubleMetricDims) {
        this.maxOutput = maxOutput;
        this.samplingSize = samplingSize;
        this.containerSize = containerSize;
        this.distributionBound = distributionBound;
        this.strategy = strategy;
        this.retainingDims = retainingDims;
        this.collapsibleDims = collapsibleDims;
        this.longMetricDims = longMetricDims;
        this.doubleMetricDims = doubleMetricDims;
    }

    @Override
    public StrategyType getStrategy() {
        return this.strategy;
    }

    @Override
    public int getMaxOutput() {
        return this.maxOutput;
    }

    @Override
    public int getSamplingSize() {
        return this.samplingSize;
    }

    @Override
    public int getContainerSize() {
        return this.containerSize;
    }

    @Override
    public double getDistributionBound() {
        return this.distributionBound;
    }

    @Override
    public NamePath[] getCollapsibleDims() {
        return this.collapsibleDims;
    }

    @Override
    public NamePath[] getRetainingDims() {
        return this.retainingDims;
    }

    @Override
    public NamePath[] getLongMetricDims() {
        return this.longMetricDims;
    }

    @Override
    public NamePath[] getDoubleMetricDims() {
        return this.doubleMetricDims;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.collapsibleDims);
        result = 31 * result + this.containerSize;
        long temp = Double.doubleToLongBits(this.distributionBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.doubleMetricDims);
        result = 31 * result + Arrays.hashCode(this.longMetricDims);
        result = 31 * result + this.maxOutput;
        result = 31 * result + Arrays.hashCode(this.retainingDims);
        result = 31 * result + this.samplingSize;
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableEventProcessorConfig other = (ImmutableEventProcessorConfig)obj;
        if (!Arrays.equals(this.collapsibleDims, other.collapsibleDims)) {
            return false;
        }
        if (this.containerSize != other.containerSize) {
            return false;
        }
        if (Double.doubleToLongBits(this.distributionBound) != Double.doubleToLongBits(other.distributionBound)) {
            return false;
        }
        if (!Arrays.equals(this.doubleMetricDims, other.doubleMetricDims)) {
            return false;
        }
        if (!Arrays.equals(this.longMetricDims, other.longMetricDims)) {
            return false;
        }
        if (this.maxOutput != other.maxOutput) {
            return false;
        }
        if (!Arrays.equals(this.retainingDims, other.retainingDims)) {
            return false;
        }
        if (this.samplingSize != other.samplingSize) {
            return false;
        }
        return this.strategy == other.strategy;
    }

    @Override
    public AdaptiveConfig getAdaptiveConfig() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Map<NamePath, ? extends AdaptiveConfig> getPerDimAdaptiveConfig() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

