/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent;

import com.mulesoft.dias.mule.agent.CertificateProcessor;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DirectoryWatcher {
    private final WatchService watchService;
    private final Set<Path> watchedFiles = new HashSet<Path>();
    private final Map<WatchKey, Path> watchKeys = new HashMap<WatchKey, Path>();
    private final CertificateProcessor certificateProcessor;
    private final Path otelConfigPath;
    private final Path muleAgentJksPath;

    public DirectoryWatcher() throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.certificateProcessor = new CertificateProcessor();
        String muleHome = System.getProperty("muleHome");
        if (muleHome == null) {
            throw new IllegalStateException("muleHome system property is not set");
        }
        this.otelConfigPath = MuleHomePath.getAMConfigPath("pipelines/otel-config.yml").toAbsolutePath();
        this.muleAgentJksPath = MuleHomePath.getConfigPath("mule-agent.jks").toAbsolutePath();
        this.registerDirectory(this.otelConfigPath.getParent());
        this.registerDirectory(this.muleAgentJksPath.getParent());
        ConsoleLogger.info("Watching directories for changes...");
        new Thread(this::monitorForNewDirectoriesAndFiles).start();
    }

    private void registerDirectory(Path directory) throws IOException {
        if (this.watchKeys.containsValue(directory)) {
            return;
        }
        WatchKey key = directory.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watchKeys.put(key, directory);
        ConsoleLogger.info("Watching directory: " + directory);
    }

    private boolean checkAndRegisterFile(Path file) {
        if (Files.exists(file, new LinkOption[0]) && !this.watchedFiles.contains(file)) {
            this.watchedFiles.add(file);
            ConsoleLogger.info("File found and watching: " + file);
            return true;
        }
        if (!this.watchedFiles.contains(file)) {
            ConsoleLogger.info("File not found, will retry: " + file);
        }
        return false;
    }

    private void monitorForNewDirectoriesAndFiles() {
        boolean otelConfigFound = false;
        boolean muleAgentJksFound = false;
        try {
            do {
                TimeUnit.SECONDS.sleep(5L);
                if (!otelConfigFound) {
                    otelConfigFound = this.checkAndRegisterFile(this.otelConfigPath);
                }
                if (muleAgentJksFound) continue;
                muleAgentJksFound = this.checkAndRegisterFile(this.muleAgentJksPath);
            } while (!otelConfigFound || !muleAgentJksFound);
            ConsoleLogger.info("All required files are now being watched.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void watch() {
        ConsoleLogger.info("Watching specific directories for file changes...");
        try {
            while (true) {
                WatchKey key;
                Path dir;
                if ((dir = this.watchKeys.get(key = this.watchService.take())) == null) {
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    Path changedFile = dir.resolve((Path)event.context()).toAbsolutePath();
                    if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !changedFile.equals(this.otelConfigPath) && !changedFile.equals(this.muleAgentJksPath)) continue;
                    ConsoleLogger.info("Detected change in: " + changedFile);
                    this.certificateProcessor.processCertificates();
                    this.restartCollector();
                }
                key.reset();
            }
        }
        catch (InterruptedException e) {
            System.err.println("Directory watching interrupted.");
            return;
        }
    }

    private void restartCollector() {
        try {
            String muleHome = System.getProperty("muleHome");
            if (muleHome == null) {
                System.err.println("muleHome system property is not set.");
                return;
            }
            String restartCommand = muleHome + "/am/bin/am restart";
            ConsoleLogger.debug("Restart command: " + restartCommand);
            String[] command = new String[]{"sh", "-c", restartCommand};
            ConsoleLogger.info("Restarting OpenTelemetry Collector...");
            Process process = new ProcessBuilder(command).start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                boolean isRunning = this.isOtelCollectorRunning();
                if (isRunning) {
                    ConsoleLogger.info("OpenTelemetry Collector restarted successfully.");
                } else {
                    System.err.println("OpenTelemetry Collector failed to start.");
                }
            } else {
                System.err.println("Error restarting OpenTelemetry Collector. Exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error during OpenTelemetry Collector restart: " + e.getMessage());
        }
    }

    private boolean isOtelCollectorRunning() {
        try {
            String line;
            String command = "ps aux | grep otel-collector | grep -v grep";
            ProcessBuilder processBuilder = new ProcessBuilder("sh", "-c", command);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("otel")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        try {
            DirectoryWatcher watcher = new DirectoryWatcher();
            watcher.watch();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

