/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.services.OnOffSwitch;
import com.mulesoft.agent.services.Switcher;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import com.mulesoft.analytics.collector.log.MetricV2LogWriter;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;

public abstract class AbstractMessageHandler
implements Switcher {
    @Configurable(value="true")
    protected boolean enabled;
    @Nullable
    private OnOffSwitch enabledSwitch;
    @Inject
    protected Configuration configuration;
    @Inject
    protected MetricLogWriter output;
    @Inject
    protected MetricV2LogWriter v2LogWriter;

    public void enable(boolean state) throws AgentEnableOperationException {
        if (this.enabledSwitch != null) {
            this.enabledSwitch.switchTo(state);
        }
    }

    @PostConfigure
    public void postConfigurable() {
        if (this.enabledSwitch == null) {
            this.enabledSwitch = OnOffSwitch.newNullSwitch((boolean)this.enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabledSwitch != null && this.enabledSwitch.isEnabled() && this.configuration.isEnabled() && this.configuration.isRunning();
    }

    List<Tuple<String, String>> createBaseTags() {
        String serverId;
        String runtimeId;
        String clusterId;
        String envId;
        ArrayList<Tuple<String, String>> tags = new ArrayList<Tuple<String, String>>();
        String orgId = this.configuration.getOrgId();
        if (orgId != null) {
            tags.add(Tuple.tuple("org_id", orgId));
        }
        if ((envId = this.configuration.getEnvId()) != null) {
            tags.add(Tuple.tuple("env_id", envId));
        }
        if ((clusterId = this.configuration.getClusterId()) != null) {
            tags.add(Tuple.tuple("cluster_id", clusterId));
        }
        if ((runtimeId = this.configuration.getRuntimeId()) != null) {
            tags.add(Tuple.tuple("worker_id", runtimeId));
        }
        if ((serverId = this.configuration.getServerId()) != null) {
            tags.add(Tuple.tuple("server_id", serverId));
        }
        return tags;
    }
}

