/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocProcessor;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.DocumentHeader;
import org.jsoup.Jsoup;

public class AsciiDocPage {
    private static Logger logger = Logger.getLogger(AsciiDocPage.class);
    private static Asciidoctor processor;
    private String baseName;
    private String filePath;
    private String asciiDoc;
    private String html;
    private String title;

    public AsciiDocPage(String filename2, String baseName, String asciiDoc, String html, String title) {
        this.validateInputParams(new String[]{filename2, asciiDoc, html});
        this.filePath = filename2;
        this.baseName = baseName;
        this.asciiDoc = asciiDoc;
        this.html = html;
        this.title = title;
    }

    public static List<AsciiDocPage> fromFiles(List<File> asciiDocFiles) {
        ArrayList<AsciiDocPage> docPages = new ArrayList<AsciiDocPage>();
        asciiDocFiles.stream().forEach(file2 -> {
            logger.debug("Creating AsciiDocPage from file: \"" + file2.getPath() + "\".");
            docPages.add(AsciiDocPage.getPageFromFile(file2));
        });
        return docPages;
    }

    public static AsciiDocPage fromFile(File asciiDocFile) {
        processor = Asciidoctor.Factory.create();
        return AsciiDocPage.getPageFromFile(asciiDocFile);
    }

    private static AsciiDocPage getPageFromFile(File asciiDocFile) {
        Utilities.validateAsciiDocFile(asciiDocFile);
        String html = AsciiDocProcessor.getProcessorInstance().convertFile(asciiDocFile);
        AsciiDocPage page = new AsciiDocPage(asciiDocFile.getPath(), FilenameUtils.getBaseName(asciiDocFile.getName()), Utilities.getFileContentsFromFile(asciiDocFile), html, AsciiDocPage.getPageTitle(html));
        return page;
    }

    public Map<String, Object> getAttributes() {
        Asciidoctor processor = this.getProcessor();
        DocumentHeader header = processor.readDocumentHeader(this.getAsciiDoc());
        return header.getAttributes();
    }

    public boolean containsAttribute(String attributeName) {
        Map<String, Object> attributes = this.getAttributes();
        return attributes.containsKey(attributeName);
    }

    public String getAttributeValue(String attributeName) {
        if (!this.containsAttribute(attributeName)) {
            return null;
        }
        Map<String, Object> attributes = this.getAttributes();
        return attributes.get(attributeName).toString();
    }

    private static String getPageTitle(String html) {
        return Jsoup.parse(html).title().trim();
    }

    private void validateInputParams(String[] params2) {
        Utilities.validateCtorStringInputParam(params2, AsciiDocPage.class.getSimpleName());
    }

    public Asciidoctor getProcessor() {
        return processor;
    }

    public static void shutdownProcessor() {
        processor.shutdown();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAsciiDoc() {
        return this.asciiDoc;
    }

    public String getHtml() {
        return this.html;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getTitle() {
        return this.title;
    }
}

