/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.TabProcessor;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.JavaExtensionRegistry;

public class AsciiDocProcessor {
    private static Logger logger = Logger.getLogger(AsciiDocProcessor.class);
    private static AsciiDocProcessor processor;
    private Asciidoctor asciidoctor = Asciidoctor.Factory.create();

    public static AsciiDocProcessor getProcessorInstance() {
        if (processor == null) {
            processor = new AsciiDocProcessor();
        }
        return processor;
    }

    private AsciiDocProcessor() {
        this.registerExtensions();
    }

    public String convertFile(File asciiDocFile) {
        logger.debug("Processing AsciiDoc file: \"" + asciiDocFile.getAbsolutePath());
        String result2 = this.asciidoctor.convertFile(asciiDocFile, this.getOptionsForConversion());
        return result2;
    }

    public String convertAsciiDocString(String asciiDoc) {
        return this.asciidoctor.convert(asciiDoc, this.getOptionsForConversion());
    }

    private void registerExtensions() {
        JavaExtensionRegistry extensionRegistry = this.asciidoctor.javaExtensionRegistry();
        extensionRegistry.block("tabs", TabProcessor.class);
    }

    private Options getOptionsForConversion() {
        Options options2 = new Options();
        options2.setBackend("html");
        options2.setToFile(false);
        options2.setHeaderFooter(true);
        options2.setSafe(SafeMode.SAFE);
        options2.setAttributes(this.getAttributesForConversion());
        return options2;
    }

    private Map<String, Object> getAttributesForConversion() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("sectanchors", "true");
        attributes.put("idprefix", "");
        attributes.put("idseparator", "-");
        attributes.put("icons", "font");
        attributes.put("source-highlighter", "coderay");
        attributes.put("coderay-linenums-mode", "table");
        attributes.put("imagesdir", "./_images");
        return attributes;
    }
}

