/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.model.TocNode;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SiteTableOfContents {
    private List<TocNode> nodes;

    public SiteTableOfContents(List<TocNode> nodes) {
        this.nodes = nodes;
    }

    public static SiteTableOfContents fromAsciiDocFile(File asciiDocFile) {
        Utilities.validateAsciiDocFile(asciiDocFile);
        AsciiDocPage asciiDocPage = AsciiDocPage.fromFile(asciiDocFile);
        List<TocNode> nodes = SiteTableOfContents.getNodesFromToc(asciiDocPage.getHtml());
        return new SiteTableOfContents(nodes);
    }

    private static List<TocNode> getNodesFromToc(String html) {
        Document tocHtml = Jsoup.parse(html, "UTF-8");
        ArrayList<TocNode> nodes = new ArrayList<TocNode>();
        Elements tocSections = tocHtml.select("li");
        for (int i2 = 0; i2 < tocSections.size(); ++i2) {
            SiteTableOfContents.getNodeFromRawTocHtml(tocHtml, nodes);
        }
        return nodes;
    }

    private static void getNodeFromRawTocHtml(Document doc, List<TocNode> nodes) {
        Element item = doc.select("li").first();
        String link2 = item.select("a").first().attr("href");
        String title = item.select("a").first().text();
        TocNode firstNode = new TocNode(link2, title, null);
        item.remove();
        nodes.add(firstNode);
    }

    public List<TocNode> getNodes() {
        return this.nodes;
    }
}

