/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class NumericEntityUnescaper
extends CharSequenceTranslator {
    private final EnumSet<OPTION> options;

    public NumericEntityUnescaper(OPTION ... options2) {
        this.options = options2.length > 0 ? EnumSet.copyOf(Arrays.asList(options2)) : EnumSet.copyOf(Arrays.asList(OPTION.semiColonRequired));
    }

    public boolean isSet(OPTION option) {
        return this.options == null ? false : this.options.contains((Object)option);
    }

    @Override
    public int translate(CharSequence input, int index2, Writer out) throws IOException {
        int seqEnd = input.length();
        if (input.charAt(index2) == '&' && index2 < seqEnd - 2 && input.charAt(index2 + 1) == '#') {
            int entityValue;
            boolean semiNext;
            int end2;
            int start2 = index2 + 2;
            boolean isHex = false;
            char firstChar = input.charAt(start2);
            if (firstChar == 'x' || firstChar == 'X') {
                isHex = true;
                if (++start2 == seqEnd) {
                    return 0;
                }
            }
            for (end2 = start2; end2 < seqEnd && (input.charAt(end2) >= '0' && input.charAt(end2) <= '9' || input.charAt(end2) >= 'a' && input.charAt(end2) <= 'f' || input.charAt(end2) >= 'A' && input.charAt(end2) <= 'F'); ++end2) {
            }
            boolean bl = semiNext = end2 != seqEnd && input.charAt(end2) == ';';
            if (!semiNext) {
                if (this.isSet(OPTION.semiColonRequired)) {
                    return 0;
                }
                if (this.isSet(OPTION.errorIfNoSemiColon)) {
                    throw new IllegalArgumentException("Semi-colon required at end of numeric entity");
                }
            }
            try {
                entityValue = isHex ? Integer.parseInt(input.subSequence(start2, end2).toString(), 16) : Integer.parseInt(input.subSequence(start2, end2).toString(), 10);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
            if (entityValue > 65535) {
                char[] chrs = Character.toChars(entityValue);
                out.write(chrs[0]);
                out.write(chrs[1]);
            } else {
                out.write(entityValue);
            }
            return 2 + end2 - start2 + (isHex ? 1 : 0) + (semiNext ? 1 : 0);
        }
        return 0;
    }

    public static enum OPTION {
        semiColonRequired,
        semiColonOptional,
        errorIfNoSemiColon;

    }
}

