/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderAttachableImpl
implements AppenderAttachable {
    protected Vector appenderList;

    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            return;
        }
        if (this.appenderList == null) {
            this.appenderList = new Vector(1);
        }
        if (!this.appenderList.contains(newAppender)) {
            this.appenderList.addElement(newAppender);
        }
    }

    public int appendLoopOnAppenders(LoggingEvent event2) {
        int size2 = 0;
        if (this.appenderList != null) {
            size2 = this.appenderList.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                Appender appender = (Appender)this.appenderList.elementAt(i2);
                appender.doAppend(event2);
            }
        }
        return size2;
    }

    public Enumeration getAllAppenders() {
        if (this.appenderList == null) {
            return null;
        }
        return this.appenderList.elements();
    }

    public Appender getAppender(String name2) {
        if (this.appenderList == null || name2 == null) {
            return null;
        }
        int size2 = this.appenderList.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Appender appender = (Appender)this.appenderList.elementAt(i2);
            if (!name2.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    public boolean isAttached(Appender appender) {
        if (this.appenderList == null || appender == null) {
            return false;
        }
        int size2 = this.appenderList.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Appender a = (Appender)this.appenderList.elementAt(i2);
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    public void removeAllAppenders() {
        if (this.appenderList != null) {
            int len = this.appenderList.size();
            for (int i2 = 0; i2 < len; ++i2) {
                Appender a = (Appender)this.appenderList.elementAt(i2);
                a.close();
            }
            this.appenderList.removeAllElements();
            this.appenderList = null;
        }
    }

    public void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            return;
        }
        this.appenderList.removeElement(appender);
    }

    public void removeAppender(String name2) {
        if (name2 == null || this.appenderList == null) {
            return;
        }
        int size2 = this.appenderList.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            if (!name2.equals(((Appender)this.appenderList.elementAt(i2)).getName())) continue;
            this.appenderList.removeElementAt(i2);
            break;
        }
    }
}

