/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class XMLLayout
extends Layout {
    private final int DEFAULT_SIZE = 256;
    private final int UPPER_LIMIT = 2048;
    private StringBuffer buf = new StringBuffer(256);
    private boolean locationInfo = false;
    private boolean properties = false;

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setProperties(boolean flag) {
        this.properties = flag;
    }

    public boolean getProperties() {
        return this.properties;
    }

    public void activateOptions() {
    }

    public String format(LoggingEvent event2) {
        Set keySet;
        String[] s2;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuffer(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(Transform.escapeTags(event2.getLoggerName()));
        this.buf.append("\" timestamp=\"");
        this.buf.append(event2.timeStamp);
        this.buf.append("\" level=\"");
        this.buf.append(Transform.escapeTags(String.valueOf(event2.getLevel())));
        this.buf.append("\" thread=\"");
        this.buf.append(Transform.escapeTags(event2.getThreadName()));
        this.buf.append("\">\r\n");
        this.buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCDATA(this.buf, event2.getRenderedMessage());
        this.buf.append("]]></log4j:message>\r\n");
        String ndc = event2.getNDC();
        if (ndc != null) {
            this.buf.append("<log4j:NDC><![CDATA[");
            Transform.appendEscapingCDATA(this.buf, ndc);
            this.buf.append("]]></log4j:NDC>\r\n");
        }
        if ((s2 = event2.getThrowableStrRep()) != null) {
            this.buf.append("<log4j:throwable><![CDATA[");
            for (int i2 = 0; i2 < s2.length; ++i2) {
                Transform.appendEscapingCDATA(this.buf, s2[i2]);
                this.buf.append("\r\n");
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            LocationInfo locationInfo = event2.getLocationInformation();
            this.buf.append("<log4j:locationInfo class=\"");
            this.buf.append(Transform.escapeTags(locationInfo.getClassName()));
            this.buf.append("\" method=\"");
            this.buf.append(Transform.escapeTags(locationInfo.getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(Transform.escapeTags(locationInfo.getFileName()));
            this.buf.append("\" line=\"");
            this.buf.append(locationInfo.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        if (this.properties && (keySet = event2.getPropertyKeySet()).size() > 0) {
            this.buf.append("<log4j:properties>\r\n");
            Object[] keys2 = keySet.toArray();
            Arrays.sort(keys2);
            for (int i3 = 0; i3 < keys2.length; ++i3) {
                String key2 = keys2[i3].toString();
                Object val = event2.getMDC(key2);
                if (val == null) continue;
                this.buf.append("<log4j:data name=\"");
                this.buf.append(Transform.escapeTags(key2));
                this.buf.append("\" value=\"");
                this.buf.append(Transform.escapeTags(String.valueOf(val)));
                this.buf.append("\"/>\r\n");
            }
            this.buf.append("</log4j:properties>\r\n");
        }
        this.buf.append("</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }
}

