/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import org.asciidoctor.ast.AbstractNode;
import org.asciidoctor.ast.AbstractNodeImpl;
import org.asciidoctor.ast.BlockImpl;
import org.asciidoctor.ast.CellImpl;
import org.asciidoctor.ast.ColumnImpl;
import org.asciidoctor.ast.DocumentImpl;
import org.asciidoctor.ast.InlineImpl;
import org.asciidoctor.ast.ListImpl;
import org.asciidoctor.ast.ListItemImpl;
import org.asciidoctor.ast.NodeCache;
import org.asciidoctor.ast.SectionImpl;
import org.asciidoctor.ast.TableImpl;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.runtime.builtin.IRubyObject;

public final class NodeConverter {
    private NodeConverter() {
    }

    public static AbstractNode createASTNode(Ruby runtime, NodeType nodeType, IRubyObject ... args2) {
        IRubyObject node = nodeType.getRubyClass(runtime).callMethod(runtime.getCurrentContext(), "new", args2);
        return NodeConverter.createASTNode(node);
    }

    public static AbstractNode createASTNode(Object object) {
        if (object instanceof IRubyObject || object instanceof RubyObjectHolderProxy) {
            IRubyObject rubyObject = NodeConverter.asRubyObject(object);
            NodeCache nodeCache = NodeCache.get(rubyObject);
            AbstractNode cachedNode = nodeCache.getASTNode();
            if (cachedNode != null) {
                return cachedNode;
            }
            Ruby runtime = rubyObject.getRuntime();
            RubyClass rubyClass = rubyObject.getMetaClass().getRealClass();
            AbstractNodeImpl ret = null;
            switch (NodeType.getNodeType(rubyClass)) {
                case BLOCK_CLASS: {
                    ret = new BlockImpl(rubyObject);
                    break;
                }
                case SECTION_CLASS: {
                    ret = new SectionImpl(rubyObject);
                    break;
                }
                case DOCUMENT_CLASS: {
                    ret = new DocumentImpl(rubyObject);
                    break;
                }
                case INLINE_CLASS: {
                    ret = new InlineImpl(rubyObject);
                    break;
                }
                case LIST_CLASS: {
                    ret = new ListImpl(rubyObject);
                    break;
                }
                case LIST_ITEM_CLASS: {
                    ret = new ListItemImpl(rubyObject);
                    break;
                }
                case TABLE_CLASS: {
                    ret = new TableImpl(rubyObject);
                    break;
                }
                case TABLE_COLUMN_CLASS: {
                    ret = new ColumnImpl(rubyObject);
                    break;
                }
                case TABLE_CELL_CLASS: {
                    ret = new CellImpl(rubyObject);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know what to do with a " + rubyObject);
                }
            }
            nodeCache.setASTNode(ret);
            return ret;
        }
        if (object instanceof AbstractNode) {
            return (AbstractNode)object;
        }
        throw new IllegalArgumentException(object != null ? object.toString() : "null");
    }

    public static IRubyObject asRubyObject(Object o) {
        if (o instanceof IRubyObject) {
            return (IRubyObject)o;
        }
        if (o instanceof RubyObjectHolderProxy) {
            return ((RubyObjectHolderProxy)o).__ruby_object();
        }
        throw new IllegalArgumentException(o.getClass() + " is not a IRubyObject nor a RubyObjectHolderProxy!");
    }

    public static enum NodeType {
        BLOCK_CLASS("Asciidoctor", "Block"),
        SECTION_CLASS("Asciidoctor", "Section"),
        DOCUMENT_CLASS("Asciidoctor", "Document"),
        INLINE_CLASS("Asciidoctor", "Inline"),
        LIST_CLASS("Asciidoctor", "List"),
        LIST_ITEM_CLASS("Asciidoctor", "ListItem"),
        TABLE_CLASS("Asciidoctor", "Table"),
        TABLE_COLUMN_CLASS("Asciidoctor", "Table", "Column"),
        TABLE_CELL_CLASS("Asciidoctor", "Table", "Cell");

        private String[] path;

        private NodeType(String ... path2) {
            this.path = path2;
        }

        public RubyClass getRubyClass(Ruby runtime) {
            RubyModule object = runtime.getModule(this.path[0]);
            RubyClass rubyClass = object.getClass(this.path[1]);
            if (this.path.length == 2) {
                return rubyClass;
            }
            return rubyClass.getClass(this.path[2]);
        }

        public static NodeType getNodeType(RubyClass rubyClass) {
            Ruby runtime = rubyClass.getRuntime();
            for (NodeType nodeType : NodeType.values()) {
                if (!nodeType.getRubyClass(runtime).equals(rubyClass)) continue;
                return nodeType;
            }
            throw new IllegalArgumentException("Don't know what to do with a " + rubyClass);
        }
    }
}

