/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Locale;
import org.jsoup.helper.Validate;

class CharacterReader {
    static final char EOF = '\uffff';
    private final char[] input;
    private final int length;
    private int pos = 0;
    private int mark = 0;

    CharacterReader(String input) {
        Validate.notNull(input);
        this.input = input.toCharArray();
        this.length = this.input.length;
    }

    int pos() {
        return this.pos;
    }

    boolean isEmpty() {
        return this.pos >= this.length;
    }

    char current() {
        return this.pos >= this.length ? (char)'\uffff' : this.input[this.pos];
    }

    char consume() {
        char val = this.pos >= this.length ? (char)'\uffff' : this.input[this.pos];
        ++this.pos;
        return val;
    }

    void unconsume() {
        --this.pos;
    }

    void advance() {
        ++this.pos;
    }

    void mark() {
        this.mark = this.pos;
    }

    void rewindToMark() {
        this.pos = this.mark;
    }

    String consumeAsString() {
        return new String(this.input, this.pos++, 1);
    }

    int nextIndexOf(char c) {
        for (int i2 = this.pos; i2 < this.length; ++i2) {
            if (c != this.input[i2]) continue;
            return i2 - this.pos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence seq) {
        char startChar = seq.charAt(0);
        for (int offset2 = this.pos; offset2 < this.length; ++offset2) {
            if (startChar != this.input[offset2]) {
                while (++offset2 < this.length && startChar != this.input[offset2]) {
                }
            }
            int i2 = offset2 + 1;
            int last2 = i2 + seq.length() - 1;
            if (offset2 >= this.length || last2 > this.length) continue;
            int j = 1;
            while (i2 < last2 && seq.charAt(j) == this.input[i2]) {
                ++i2;
                ++j;
            }
            if (i2 != last2) continue;
            return offset2 - this.pos;
        }
        return -1;
    }

    String consumeTo(char c) {
        int offset2 = this.nextIndexOf(c);
        if (offset2 != -1) {
            String consumed = new String(this.input, this.pos, offset2);
            this.pos += offset2;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq) {
        int offset2 = this.nextIndexOf(seq);
        if (offset2 != -1) {
            String consumed = new String(this.input, this.pos, offset2);
            this.pos += offset2;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeToAny(char ... chars2) {
        int start2 = this.pos;
        block0: while (this.pos < this.length) {
            for (int i2 = 0; i2 < chars2.length; ++i2) {
                if (this.input[this.pos] == chars2[i2]) break block0;
            }
            ++this.pos;
        }
        return this.pos > start2 ? new String(this.input, start2, this.pos - start2) : "";
    }

    String consumeToEnd() {
        String data2 = new String(this.input, this.pos, this.length - this.pos);
        this.pos = this.length;
        return data2;
    }

    String consumeLetterSequence() {
        char c;
        int start2 = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            ++this.pos;
        }
        return new String(this.input, start2, this.pos - start2);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        int start2 = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            ++this.pos;
        }
        while (!this.isEmpty() && (c = this.input[this.pos]) >= '0' && c <= '9') {
            ++this.pos;
        }
        return new String(this.input, start2, this.pos - start2);
    }

    String consumeHexSequence() {
        char c;
        int start2 = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.pos;
        }
        return new String(this.input, start2, this.pos - start2);
    }

    String consumeDigitSequence() {
        char c;
        int start2 = this.pos;
        while (this.pos < this.length && (c = this.input[this.pos]) >= '0' && c <= '9') {
            ++this.pos;
        }
        return new String(this.input, start2, this.pos - start2);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.input[this.pos] == c;
    }

    boolean matches(String seq) {
        int scanLength = seq.length();
        if (scanLength > this.length - this.pos) {
            return false;
        }
        for (int offset2 = 0; offset2 < scanLength; ++offset2) {
            if (seq.charAt(offset2) == this.input[this.pos + offset2]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String seq) {
        int scanLength = seq.length();
        if (scanLength > this.length - this.pos) {
            return false;
        }
        for (int offset2 = 0; offset2 < scanLength; ++offset2) {
            char upTarget;
            char upScan = Character.toUpperCase(seq.charAt(offset2));
            if (upScan == (upTarget = Character.toUpperCase(this.input[this.pos + offset2]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        for (char seek2 : seq) {
            if (seek2 != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String seq) {
        if (this.matches(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq) {
        String loScan = seq.toLowerCase(Locale.ENGLISH);
        String hiScan = seq.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(loScan) > -1 || this.nextIndexOf(hiScan) > -1;
    }

    public String toString() {
        return new String(this.input, this.pos, this.length - this.pos);
    }
}

