/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.model.TocNode;
import com.mulesoft.documentation.builder.util.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class Breadcrumb {
    private static Logger logger = Logger.getLogger(Breadcrumb.class);
    private TocNode root;

    public Breadcrumb(TocNode root) {
        this.root = root;
    }

    public static Breadcrumb fromRootNode(TocNode rootNode) {
        Breadcrumb.validateInputParams(new Object[]{rootNode});
        return new Breadcrumb(rootNode);
    }

    public String getHtmlForActiveUrl(String activeUrl, String baseUrl) {
        if (!Utilities.isActiveUrlInSection(this.root, activeUrl, false)) {
            return "";
        }
        return this.generateBreadcrumbsForActiveUrl(activeUrl, baseUrl);
    }

    private String generateBreadcrumbsForActiveUrl(String activeUrl, String baseUrl) {
        List<TocNode> nodes = this.getBreadcrumbs(activeUrl);
        logger.debug("Creating breadcrumb for \"" + baseUrl + "/" + activeUrl + "\".");
        StringBuilder html = new StringBuilder("<div class=\"breadcrumb-section\" data-swiftype-index='false'>");
        for (TocNode node : nodes) {
            if (node.getUrl().equals("")) {
                node.setUrl("./");
            }
            String url = Utilities.getConcatPath(new String[]{baseUrl, node.getUrl()});
            if (!node.getUrl().equals(activeUrl)) {
                html.append("<a href=\"" + url + "\">" + node.getTitle() + "</a>/");
            } else {
                html.append("<a href=\"" + url + "\" class=\"breadcrumb-active-link\">" + node.getTitle() + "</a>");
            }
            if (!node.getUrl().equals("./")) continue;
            node.setUrl("");
        }
        html.append("</div>");
        return html.toString();
    }

    public List<TocNode> getBreadcrumbs(String activeUrl) {
        Utilities.validateIfActiveUrlIsInSection(this.root, activeUrl);
        ArrayList<TocNode> activeNode = new ArrayList<TocNode>();
        ArrayList<TocNode> nodes = new ArrayList<TocNode>();
        Breadcrumb.getActiveNode(this.root, activeUrl, activeNode);
        TocNode current2 = (TocNode)activeNode.get(0);
        nodes.add(current2);
        while (current2.getParent() != null) {
            nodes.add(current2.getParent());
            current2 = current2.getParent();
        }
        Collections.reverse(nodes);
        return nodes;
    }

    public static void getActiveNode(TocNode parentNode, String activeUrl, List<TocNode> activeNode) {
        if (parentNode.getUrl().equals(activeUrl)) {
            activeNode.add(parentNode);
            return;
        }
        if (parentNode.getChildren().size() > 0) {
            for (TocNode node : parentNode.getChildren()) {
                Breadcrumb.getActiveNode(node, activeUrl, activeNode);
            }
        }
    }

    private static void validateInputParams(Object[] params2) {
        Utilities.validateCtorObjectsAreNotNull(params2, Breadcrumb.class.getSimpleName());
    }
}

