/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.PdfAsciiDocProcessor;
import com.mulesoft.documentation.builder.Section;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class PdfGenerator {
    private static Logger logger = Logger.getLogger(PdfGenerator.class);
    private File outputDirectory;
    private Map<String, String> createdPdfRegistry;

    public PdfGenerator(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.createdPdfRegistry = new HashMap<String, String>();
    }

    public void processAllSections(List<Section> sections) {
        for (Section section : sections) {
            this.processSection(section);
        }
    }

    public void processSection(Section section) {
        String sectionOutputPath = Utilities.getConcatPath(new String[]{this.outputDirectory.getPath(), Utilities.removeLeadingSlashes(section.getUrl())});
        try {
            File sectionOutputDir = new File(sectionOutputPath);
            FileUtils.forceMkdir(sectionOutputDir);
            for (AsciiDocPage page : section.getPages()) {
                this.createPdf(page, section, sectionOutputPath);
            }
        }
        catch (IOException e) {
            logger.error("Error creating new directory for section PDFs: " + sectionOutputPath, e);
        }
    }

    public void createPdf(AsciiDocPage page, Section section, String sectionOutputPath) {
        PdfAsciiDocProcessor processor = PdfAsciiDocProcessor.getProcessorInstance();
        String outputFilePath = Utilities.getConcatPath(new String[]{sectionOutputPath, this.getPdfFileName(page, section)});
        boolean successful = processor.convertAsciiDocStringToPdfFile(page.getAsciiDoc(), page.getFilePath(), outputFilePath);
        if (successful) {
            this.createdPdfRegistry.put(page.getFilePath(), outputFilePath);
        }
    }

    private String getPdfFileName(AsciiDocPage page, Section section) {
        return "mulesoft-docs--" + section.getBaseName() + "--" + page.getBaseName() + ".pdf";
    }

    public Map<String, String> getCreatedPdfRegistry() {
        return this.createdPdfRegistry;
    }
}

