/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.DocBuildException;
import com.mulesoft.documentation.builder.Page;
import com.mulesoft.documentation.builder.Section;
import com.mulesoft.documentation.builder.SiteTableOfContents;
import com.mulesoft.documentation.builder.Template;
import com.mulesoft.documentation.builder.model.SectionConfiguration;
import com.mulesoft.documentation.builder.model.SectionVersion;
import com.mulesoft.documentation.builder.model.TocNode;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class SiteBuilder {
    private static Logger logger = Logger.getLogger(SiteBuilder.class);
    private List<Section> sections;
    private SiteTableOfContents toc;
    private File sourceDirectory;
    private File outputDirectory;
    private String gitHubRepoUrl;
    private String gitHubBranchName;
    private List<Template> templates;
    private List<SectionVersion> allSectionVersions;
    private String siteRootUrl;

    public SiteBuilder(File sourceDirectory, File outputDirectory, String gitHubRepoUrl, String gitHubBranchName, String siteRootUrl) {
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
        this.gitHubRepoUrl = gitHubRepoUrl;
        this.gitHubBranchName = gitHubBranchName;
        this.siteRootUrl = siteRootUrl;
        this.sections = new ArrayList<Section>();
    }

    public void buildSite() {
        this.getSectionsAndVersions();
        this.toc = this.getSiteToc(this.sourceDirectory);
        this.templates = this.getTemplates(this.sourceDirectory);
        this.writeSections();
    }

    public void getSectionsAndVersions() {
        ArrayList<SectionVersion> versions = new ArrayList<SectionVersion>();
        if (this.sourceDirectory.isDirectory()) {
            File[] files = this.sourceDirectory.listFiles();
            if (files != null) {
                for (File parentSectionDir : files) {
                    if (!parentSectionDir.isDirectory()) continue;
                    this.getVersionSections(parentSectionDir, versions);
                }
            } else {
                throw new DocBuildException("Source directory for sections was null.");
            }
        }
        this.allSectionVersions = versions;
    }

    private void getVersionSections(File sectionMasterPath, List<SectionVersion> versions) {
        File versionDir = new File(Utilities.getConcatPath(new String[]{sectionMasterPath.getAbsolutePath(), "v"}));
        if (versionDir.exists() && versionDir.isDirectory()) {
            File[] versionSectionDirectories = versionDir.listFiles();
            if (versionSectionDirectories != null) {
                for (File versionDirectory : versionSectionDirectories) {
                    if (!this.isValidSectionDirectory(versionDirectory)) continue;
                    SectionVersion sectionVersion = this.getVersionFromSectionAndConfiguration(versionDirectory);
                    versions.add(sectionVersion);
                    Section section = Section.fromDirectoryAndSectionVersion(versionDirectory, sectionVersion);
                    this.sections.add(section);
                }
            } else {
                throw new DocBuildException("FAILED processing section version path because path was null: " + versionDir.getAbsolutePath());
            }
        }
    }

    private SectionVersion getVersionFromSectionAndConfiguration(File versionDirectory) {
        SectionConfiguration config = this.getConfigurationForSection(versionDirectory);
        File vDir = versionDirectory.getParentFile();
        String sectionDirectoryBaseName = vDir.getParentFile().getName();
        String versionUrl = "";
        versionUrl = !config.getVersionName().equals("latest") ? "/" + sectionDirectoryBaseName + "/v/" + config.getVersionName() : "/" + sectionDirectoryBaseName;
        return new SectionVersion(config.getSectionName(), sectionDirectoryBaseName, versionUrl, config.getVersionName(), config.isLatest());
    }

    private SectionConfiguration getConfigurationForSection(File sectionDirectory) {
        File[] filesInSection;
        if (sectionDirectory.isDirectory() && (filesInSection = sectionDirectory.listFiles()) != null) {
            for (File file2 : filesInSection) {
                if (!file2.getName().equals("_config.yml")) continue;
                FileInputStream input = null;
                try {
                    input = new FileInputStream(file2);
                }
                catch (FileNotFoundException e) {
                    throw new DocBuildException("Couldn't process _config.yml file for section: " + sectionDirectory.getAbsolutePath());
                }
                return this.getConfigurationFromInputYaml(input);
            }
        }
        throw new DocBuildException("Section didn't have a _config.yml file: " + sectionDirectory);
    }

    private SectionConfiguration getConfigurationFromInputYaml(InputStream input) {
        Yaml yaml = new Yaml();
        LinkedHashMap map = (LinkedHashMap)yaml.load(input);
        if (map != null) {
            Map configMap = (Map)map.get("configuration");
            Object version = configMap.get("versionName");
            String versionName = version.toString();
            Object latest = configMap.get("isLatest");
            boolean isLatest = (Boolean)latest;
            String sectionName = (String)configMap.get("sectionName");
            map = null;
            configMap = null;
            return new SectionConfiguration(sectionName, versionName, isLatest);
        }
        throw new DocBuildException("Couldn't parse _config.yml beacuse Yaml Map was null.");
    }

    private void writeSections() {
        this.sections.parallelStream().forEach(section -> {
            String sectionPath = !section.getVersionPrettyName().contentEquals("latest") ? Utilities.getConcatPath(new String[]{this.outputDirectory.getPath(), section.getBaseName(), "v", section.getVersionPrettyName()}) : Utilities.getConcatPath(new String[]{this.outputDirectory.getPath(), section.getBaseName()});
            Utilities.makeTargetDirectory(sectionPath);
            logger.info("Writing pages for section \"" + section.getPrettyName() + "\".");
            this.writePagesForSection((Section)section, sectionPath);
            this.writeAssets(section.getFilepath(), sectionPath);
        });
        this.writeHomePage(Utilities.getConcatPath(new String[]{this.sourceDirectory.getAbsolutePath(), "index.adoc"}));
    }

    public void writeHomePage(String pathToPage) {
        AsciiDocPage adocPage = AsciiDocPage.fromFile(new File(pathToPage));
        ArrayList<AsciiDocPage> adocPages = new ArrayList<AsciiDocPage>();
        adocPages.add(adocPage);
        SectionVersion sectionVersion = new SectionVersion("", "", "", "", true);
        TocNode rootNode = new TocNode("", "MuleSoft Documentation Home", null);
        Section section = new Section(adocPages, rootNode, pathToPage, "", "", "", "", sectionVersion);
        ArrayList<SectionVersion> sectionVersions = new ArrayList<SectionVersion>();
        sectionVersions.add(sectionVersion);
        List<Page> page = Page.forSection(section, this.sections, this.templates, this.toc, this.gitHubRepoUrl, this.gitHubBranchName, sectionVersions, this.siteRootUrl);
        Page createdPage = page.get(0);
        String pagePath = Utilities.getConcatPath(new String[]{this.outputDirectory.getPath(), createdPage.getBaseName()}) + ".html";
        logger.info("Writing page \"" + pagePath + "\"...");
        Utilities.writeFileToDirectory(pagePath, createdPage.getContent());
    }

    private void writeAssets(String originalSectionPath, String destSectionPath) {
        File destSectionDir;
        File sectionDir = new File(originalSectionPath);
        if (sectionDir.exists()) {
            String imageDirPath = Utilities.getConcatPath(new String[]{sectionDir.getAbsolutePath(), "_images"});
            File imageDir = new File(imageDirPath);
            destSectionDir = new File(destSectionPath);
            if (imageDir.exists() && destSectionDir.exists()) {
                try {
                    File newImgDir = new File(Utilities.getConcatPath(new String[]{destSectionDir.getAbsolutePath(), "_images"}));
                    if (!newImgDir.exists()) {
                        Utilities.makeTargetDirectory(newImgDir.getAbsolutePath());
                    }
                    FileUtils.copyDirectory(imageDir, newImgDir);
                }
                catch (IOException e) {
                    throw new DocBuildException("Couldn't create destination image directory for section: " + imageDir.getAbsolutePath());
                }
            }
        }
        if (sectionDir.exists()) {
            String attachmentsDirPath = Utilities.getConcatPath(new String[]{sectionDir.getAbsolutePath(), "_attachments"});
            File attachmentsDir = new File(attachmentsDirPath);
            destSectionDir = new File(destSectionPath);
            if (attachmentsDir.exists() && destSectionDir.exists()) {
                try {
                    File newAttachmentsDir = new File(Utilities.getConcatPath(new String[]{destSectionDir.getAbsolutePath(), "_attachments"}));
                    if (!newAttachmentsDir.exists()) {
                        Utilities.makeTargetDirectory(newAttachmentsDir.getAbsolutePath());
                    }
                    FileUtils.copyDirectory(attachmentsDir, newAttachmentsDir);
                }
                catch (IOException e) {
                    throw new DocBuildException("Couldn't create destination attachments directory for section: " + attachmentsDir.getAbsolutePath());
                }
            }
        }
    }

    private List<Template> getTemplates(File sourceDirectory) {
        File[] templateFiles;
        ArrayList<Template> templates = new ArrayList<Template>();
        File templateDirectory = new File(Utilities.getConcatPath(new String[]{sourceDirectory.getPath(), "_templates"}));
        if (templateDirectory.isDirectory() && (templateFiles = templateDirectory.listFiles()) != null) {
            for (File templateFile : templateFiles) {
                if (!FilenameUtils.getExtension(templateFile.getName()).equalsIgnoreCase("template")) continue;
                templates.add(Template.fromFile(templateFile));
            }
        }
        return templates;
    }

    public List<SectionVersion> getSectionVersionCollectionForSectionBaseName(String sectionBaseName) {
        ArrayList<SectionVersion> versionsForSection = new ArrayList<SectionVersion>();
        for (SectionVersion version : this.allSectionVersions) {
            if (!version.getSectionBaseName().equals(sectionBaseName)) continue;
            versionsForSection.add(version);
        }
        return versionsForSection;
    }

    private void writePagesForSection(Section section, String sectionPath) {
        List<SectionVersion> sectionVersions = this.getSectionVersionCollectionForSectionBaseName(section.getBaseName());
        List<Page> pages = Page.forSection(section, this.sections, this.templates, this.toc, this.gitHubRepoUrl, this.gitHubBranchName, sectionVersions, this.siteRootUrl);
        for (Page page : pages) {
            String pagePath = Utilities.getConcatPath(new String[]{sectionPath, page.getBaseName()}) + ".html";
            logger.debug("Writing page \"" + pagePath + "\"...");
            Utilities.writeFileToDirectory(pagePath, page.getContent());
        }
    }

    private SiteTableOfContents getSiteToc(File masterDirectory) {
        File masterTocFile = new File(Utilities.getConcatPath(new String[]{masterDirectory.getPath(), "_toc.adoc"}));
        return SiteTableOfContents.fromAsciiDocFile(masterTocFile);
    }

    private boolean isValidSectionDirectory(File directory) {
        return directory.isDirectory() && !directory.isHidden() && !directory.getName().startsWith("_") && !directory.getName().equals(".DS_Store") && !directory.getName().equals("_images");
    }
}

