/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.Elements;

public class SwiftTypeMetadata {
    private static Logger logger = Logger.getLogger(SwiftTypeMetadata.class);

    public static String fromAsciiDocPage(AsciiDocPage page) {
        return SwiftTypeMetadata.getMetadataEntries(page);
    }

    public static String getMetadataEntries(AsciiDocPage page) {
        logger.debug("Creating SwiftType metadata for page \"" + page.getTitle() + "\"...");
        String result2 = "";
        result2 = result2 + SwiftTypeMetadata.getTitleMetadata(page);
        return result2;
    }

    public static String getTitleMetadata(AsciiDocPage page) {
        String result2 = "<meta class=\"swiftype\" name=\"title\" data-type=\"string\" content=";
        result2 = result2 + "\"" + page.getTitle().trim() + "\" />\n";
        return result2;
    }

    public static String getBodyMetadata(AsciiDocPage page) {
        String bodyText = SwiftTypeMetadata.getDescription(page);
        if (bodyText.length() > 0) {
            String result2 = "    <meta class=\"swiftype\" name=\"body\" data-type=\"text\" content=";
            result2 = result2 + "\"" + bodyText + "\" />\n";
            return result2;
        }
        return "";
    }

    public static String getDescription(AsciiDocPage page) {
        String result2 = "";
        Document doc = Jsoup.parse(page.getHtml(), "UTF-8");
        Elements paragraphs = doc.getElementsByClass("paragraph");
        if (paragraphs != null && paragraphs.size() > 0) {
            result2 = SwiftTypeMetadata.getShortenedDescription(paragraphs);
        }
        return result2;
    }

    private static String getShortenedDescription(List<Element> paragraphs) {
        int max2;
        String result2 = "";
        for (Element para : paragraphs) {
            result2 = result2 + Jsoup.clean(para.html(), Whitelist.none());
            if ((result2 = result2 + " ").length() < 147) continue;
            break;
        }
        result2 = (max2 = result2.length()) < 147 ? result2.substring(0, max2) : result2.substring(0, 147);
        result2 = SwiftTypeMetadata.formatEndOfDescriptionTag(result2);
        result2 = StringEscapeUtils.unescapeHtml4(result2);
        return result2;
    }

    private static String formatEndOfDescriptionTag(String text) {
        if (text.endsWith(".")) {
            text = text + "..";
        } else if (text.endsWith(",") || text.endsWith(";") || text.endsWith(":") || text.endsWith("'") || text.endsWith("\"") || text.endsWith("-") || text.endsWith("--")) {
            int length2 = text.length();
            text = text.substring(0, length2 - 2) + "...";
        } else {
            text = text + "...";
        }
        return text;
    }
}

